/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.opentest4j.MultipleFailuresError;
import org.opentest4j.TestAbortedException;
import org.opentest4j.TestSkippedException;
import org.opentest4j.ValueWrapper;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.ErrorInfoCollector;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.runtime.MasterRunListener;
import org.spockframework.runtime.SpockComparisonFailure;
import org.spockframework.runtime.condition.IObjectRenderer;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.TextUtil;

class MasterRunSupervisor
implements IRunSupervisor {
    private final IStackTraceFilter filter;
    private final IRunListener masterListener;
    private final IObjectRenderer<Object> diffedObjectRenderer;

    MasterRunSupervisor(SpecInfo specInfo, IStackTraceFilter filter, IObjectRenderer<Object> diffedObjectRenderer) {
        this.masterListener = new MasterRunListener(specInfo);
        this.filter = filter;
        this.diffedObjectRenderer = diffedObjectRenderer;
    }

    @Override
    public void beforeSpec(SpecInfo spec) {
        this.masterListener.beforeSpec(spec);
    }

    @Override
    public void beforeFeature(FeatureInfo feature) {
        this.masterListener.beforeFeature(feature);
    }

    @Override
    public void beforeIteration(IterationInfo iteration) {
        this.masterListener.beforeIteration(iteration);
    }

    @Override
    public void error(ErrorInfoCollector errorInfoCollector, ErrorInfo error) {
        Throwable exception = error.getException();
        if (exception instanceof MultipleFailuresError) {
            this.handleMultipleFailures(errorInfoCollector, error);
            return;
        }
        exception = this.transform(exception);
        ErrorInfo transformedError = new ErrorInfo(error.getMethod(), exception, error.getErrorContext());
        if (!(exception instanceof TestAbortedException) && !(exception instanceof TestSkippedException)) {
            this.masterListener.error(transformedError);
        }
        errorInfoCollector.addErrorInfo(transformedError);
    }

    private void handleMultipleFailures(ErrorInfoCollector errorInfoCollector, ErrorInfo error) {
        MultipleFailuresError multiFailure = (MultipleFailuresError)error.getException();
        for (Throwable failure : multiFailure.getFailures()) {
            this.error(errorInfoCollector, new ErrorInfo(error.getMethod(), failure, error.getErrorContext()));
        }
    }

    private Throwable transform(Throwable throwable) {
        if (this.isFailedEqualityComparison(throwable)) {
            throwable = this.convertToComparisonFailure(throwable);
        }
        this.filter.filter(throwable);
        return throwable;
    }

    private boolean isFailedEqualityComparison(Throwable exception) {
        if (!(exception instanceof ConditionNotSatisfiedError)) {
            return false;
        }
        ConditionNotSatisfiedError conditionNotSatisfiedError = (ConditionNotSatisfiedError)((Object)exception);
        Condition condition = conditionNotSatisfiedError.getCondition();
        ExpressionInfo expr = condition.getExpression();
        return expr != null && expr.isEqualityComparison() && conditionNotSatisfiedError.getCause() == null;
    }

    private Throwable convertToComparisonFailure(Throwable exception) {
        assert (this.isFailedEqualityComparison(exception));
        ConditionNotSatisfiedError conditionNotSatisfiedError = (ConditionNotSatisfiedError)((Object)exception);
        Condition condition = conditionNotSatisfiedError.getCondition();
        ExpressionInfo expr = condition.getExpression();
        Object actualValue = expr.getChildren().get(0).getValue();
        ValueWrapper actual = ValueWrapper.create((Object)actualValue, (String)this.renderValue(actualValue));
        Object expectedValue = expr.getChildren().get(1).getValue();
        ValueWrapper expected = ValueWrapper.create((Object)expectedValue, (String)this.renderValue(expectedValue));
        SpockComparisonFailure failure = new SpockComparisonFailure(condition, expected, actual);
        failure.setStackTrace(exception.getStackTrace());
        if (conditionNotSatisfiedError.getCause() != null) {
            failure.initCause(conditionNotSatisfiedError.getCause());
        }
        return failure;
    }

    private String renderValue(Object value) {
        try {
            return this.diffedObjectRenderer.render(value);
        }
        catch (Throwable t) {
            return "Failed to render value due to:\n\n" + TextUtil.printStackTrace(t);
        }
    }

    @Override
    public void afterIteration(IterationInfo iteration) {
        this.masterListener.afterIteration(iteration);
    }

    @Override
    public void afterFeature(FeatureInfo feature) {
        this.masterListener.afterFeature(feature);
    }

    @Override
    public void afterSpec(SpecInfo spec) {
        this.masterListener.afterSpec(spec);
    }

    @Override
    public void specSkipped(SpecInfo spec) {
        this.masterListener.specSkipped(spec);
    }

    @Override
    public void featureSkipped(FeatureInfo feature) {
        this.masterListener.featureSkipped(feature);
    }
}

