/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Optional;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.junit.platform.engine.support.hierarchical.ForkJoinPoolHierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfiguration;
import org.spockframework.runtime.ClassSelectorResolver;
import org.spockframework.runtime.DefaultParallelExecutionConfiguration;
import org.spockframework.runtime.MethodSelectorResolver;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.SpecUtil;
import org.spockframework.runtime.SpockEngineDescriptor;
import org.spockframework.runtime.SpockEngineDiscoveryPostProcessor;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.util.SpockReleaseInfo;
import spock.config.RunnerConfiguration;

public class SpockEngine
extends HierarchicalTestEngine<SpockExecutionContext> {
    public String getId() {
        return "spock";
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        RunContext runContext = RunContext.get();
        SpockEngineDescriptor engineDescriptor = new SpockEngineDescriptor(uniqueId, runContext);
        EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver(SpecUtil::isRunnableSpec).addSelectorResolver(context -> new ClassSelectorResolver(context.getClassNameFilter(), runContext)).addSelectorResolver((SelectorResolver)new MethodSelectorResolver()).build().resolve(discoveryRequest, (TestDescriptor)engineDescriptor);
        return new SpockEngineDiscoveryPostProcessor().postProcessEngineDescriptor(uniqueId, runContext, engineDescriptor);
    }

    protected SpockExecutionContext createExecutionContext(ExecutionRequest request) {
        return new SpockExecutionContext(request.getEngineExecutionListener());
    }

    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request) {
        SpockEngineDescriptor rootTestDescriptor = (SpockEngineDescriptor)request.getRootTestDescriptor();
        RunnerConfiguration configuration = rootTestDescriptor.getRunContext().getConfiguration(RunnerConfiguration.class);
        if (configuration.parallel.enabled) {
            DefaultParallelExecutionConfiguration parallelExecutionConfiguration = configuration.parallel.getParallelExecutionConfiguration();
            if (parallelExecutionConfiguration == null) {
                throw new SpockException("Parallel execution was enabled, but no parallel execution was defined.");
            }
            if (parallelExecutionConfiguration.getParallelism() > 1) {
                return new ForkJoinPoolHierarchicalTestExecutorService((ParallelExecutionConfiguration)parallelExecutionConfiguration);
            }
        }
        return super.createExecutorService(request);
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.spockframework");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("spock-core");
    }

    public Optional<String> getVersion() {
        return Optional.of(SpockReleaseInfo.getVersion().toString());
    }
}

