/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.SpockExecution;
import org.spockframework.runtime.SpockExecutionContext;

public class SpockEngineDescriptor
extends EngineDescriptor
implements Node<SpockExecutionContext> {
    private final RunContext runContext;

    public SpockEngineDescriptor(UniqueId uniqueId, RunContext runContext) {
        super(uniqueId, "Spock");
        this.runContext = runContext;
    }

    public SpockExecutionContext prepare(SpockExecutionContext context) throws Exception {
        return context.withRunContext(this.runContext);
    }

    public SpockExecutionContext before(SpockExecutionContext context) throws Exception {
        SpockExecution spockExecution = new SpockExecution(context.getStoreProvider());
        context.getRunContext().startExecution(spockExecution);
        return context;
    }

    public void after(SpockExecutionContext context) throws Exception {
        ThrowableCollector collector = new ThrowableCollector(__ -> false);
        SpockExecution spockExecution = new SpockExecution(context.getStoreProvider());
        collector.execute(() -> this.runContext.stopExecution(spockExecution));
        collector.execute(this.runContext::stop);
        collector.execute(context.getStoreProvider()::close);
        collector.assertEmpty();
    }

    RunContext getRunContext() {
        return this.runContext;
    }
}

