/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Method;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.spockframework.runtime.ErrorSpecNode;
import org.spockframework.runtime.FeatureNode;
import org.spockframework.runtime.IterationNode;
import org.spockframework.runtime.ParameterizedFeatureNode;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.SimpleFeatureNode;
import org.spockframework.runtime.SpecNode;
import org.spockframework.runtime.SpockEngineDescriptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.RunnerConfiguration;

class SpockEngineDiscoveryPostProcessor {
    private static final Object[] EMPTY_ARGS = new Object[0];

    SpockEngineDiscoveryPostProcessor() {
    }

    SpockEngineDescriptor postProcessEngineDescriptor(UniqueId uniqueId, RunContext runContext, SpockEngineDescriptor engineDescriptor) {
        SpockEngineDescriptor processedEngineDescriptor = new SpockEngineDescriptor(uniqueId, runContext);
        engineDescriptor.getChildren().stream().map(child -> this.processSpecNode((TestDescriptor)child, runContext)).forEach(arg_0 -> ((SpockEngineDescriptor)processedEngineDescriptor).addChild(arg_0));
        return processedEngineDescriptor;
    }

    private FeatureNode createNode(SpecNode specNode, FeatureInfo feature, RunnerConfiguration configuration) {
        if (feature.isParameterized()) {
            return this.describeParameterizedFeature(specNode.getUniqueId(), feature, configuration);
        }
        return this.describeSimpleFeature(specNode.getUniqueId(), feature, configuration);
    }

    private FeatureNode describeParameterizedFeature(UniqueId parentId, FeatureInfo feature, RunnerConfiguration configuration) {
        return new ParameterizedFeatureNode(this.toUniqueId(parentId, feature), configuration, feature);
    }

    private FeatureNode describeSimpleFeature(UniqueId parentId, FeatureInfo feature, RunnerConfiguration configuration) {
        IterationInfo iterationInfo = new IterationInfo(feature, 0, EMPTY_ARGS, 1);
        iterationInfo.setName(feature.getName());
        UniqueId uniqueId = this.toUniqueId(parentId, feature);
        IterationNode iterationNode = new IterationNode(this.toUniqueId(uniqueId, feature), configuration, iterationInfo);
        return new SimpleFeatureNode(uniqueId, configuration, feature, iterationNode);
    }

    private UniqueId toUniqueId(UniqueId parentId, FeatureInfo feature) {
        return parentId.append("feature", ((Method)feature.getFeatureMethod().getReflection()).getName());
    }

    private TestDescriptor processSpecNode(TestDescriptor child, RunContext runContext) {
        if (child instanceof SpecNode) {
            SpecNode specNode = (SpecNode)child;
            RunnerConfiguration configuration = runContext.getConfiguration(RunnerConfiguration.class);
            SpecInfo nodeInfo = (SpecInfo)specNode.getNodeInfo();
            try {
                runContext.createExtensionRunner(nodeInfo).run();
            }
            catch (Exception e) {
                return new ErrorSpecNode(specNode.getUniqueId(), configuration, nodeInfo, e);
            }
            SpecNode resultNode = new SpecNode(specNode.getUniqueId(), configuration, nodeInfo);
            nodeInfo.getAllFeaturesInExecutionOrder().stream().filter(featureInfo -> !featureInfo.isExcluded()).map(featureInfo -> this.createNode(resultNode, (FeatureInfo)featureInfo, configuration)).forEach(arg_0 -> ((SpecNode)resultNode).addChild(arg_0));
            return resultNode;
        }
        return child;
    }
}

