/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.PrintStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.spockframework.runtime.IStandardStreamsListener;
import org.spockframework.util.IStoppable;
import org.spockframework.util.StringMessagePrintStream;
import org.spockframework.util.TeePrintStream;

public class StandardStreamsCapturer
implements IStoppable {
    private final Set<IStandardStreamsListener> standardStreamsListeners = new CopyOnWriteArraySet<IStandardStreamsListener>();
    private volatile TeePrintStream outStream;
    private volatile TeePrintStream errStream;

    public synchronized void start() {
        this.startCapture(System.out, this.outStream, true);
        this.startCapture(System.err, this.errStream, false);
    }

    private void startCapture(PrintStream originalStream, TeePrintStream teeStream, final boolean isOut) {
        if (originalStream == teeStream) {
            return;
        }
        StringMessagePrintStream notifyingStream = new StringMessagePrintStream(){

            @Override
            protected void printed(String message) {
                for (IStandardStreamsListener listener : StandardStreamsCapturer.this.standardStreamsListeners) {
                    if (isOut) {
                        listener.standardOut(message);
                        continue;
                    }
                    listener.standardErr(message);
                }
            }
        };
        teeStream = new TeePrintStream(originalStream, (PrintStream)notifyingStream);
        if (isOut) {
            this.outStream = teeStream;
            System.setOut(teeStream);
        } else {
            this.errStream = teeStream;
            System.setErr(teeStream);
        }
    }

    @Override
    public synchronized void stop() {
        this.stopCapture(System.out, this.outStream, true);
        this.stopCapture(System.err, this.errStream, false);
    }

    private void stopCapture(PrintStream originalStream, TeePrintStream teeStream, boolean isOut) {
        if (originalStream != teeStream) {
            return;
        }
        if (isOut) {
            System.setOut(teeStream.getOriginal());
        } else {
            System.setErr(teeStream.getOriginal());
        }
    }

    public synchronized void muteStandardStreams() {
        if (this.outStream != null) {
            this.outStream.muteOriginal();
        }
        if (this.errStream != null) {
            this.errStream.muteOriginal();
        }
    }

    public synchronized void unmuteStandardStreams() {
        if (this.outStream != null) {
            this.outStream.unmuteOriginal();
        }
        if (this.errStream != null) {
            this.errStream.unmuteOriginal();
        }
    }

    public void addStandardStreamsListener(IStandardStreamsListener listener) {
        this.standardStreamsListeners.add(listener);
    }

    public void removeStandardStreamsListener(IStandardStreamsListener listener) {
        this.standardStreamsListeners.remove(listener);
    }
}

