/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import java.lang.annotation.Annotation;
import java.util.List;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.ParameterInfo;
import org.spockframework.runtime.model.SpecInfo;

public interface IAnnotationDrivenExtension<T extends Annotation> {
    default public void visitSpecAnnotations(List<T> annotations, SpecInfo spec) {
        for (Annotation annotation : annotations) {
            this.visitSpecAnnotation(annotation, spec);
        }
    }

    default public void visitSpecAnnotation(T annotation, SpecInfo spec) {
        throw new InvalidSpecException("@%s may not be applied to Specs").withArgs(annotation.annotationType().getSimpleName());
    }

    default public void visitFieldAnnotations(List<T> annotations, FieldInfo field) {
        for (Annotation annotation : annotations) {
            this.visitFieldAnnotation(annotation, field);
        }
    }

    default public void visitFieldAnnotation(T annotation, FieldInfo field) {
        throw new InvalidSpecException("@%s may not be applied to fields").withArgs(annotation.annotationType().getSimpleName());
    }

    default public void visitFixtureAnnotations(List<T> annotations, MethodInfo fixtureMethod) {
        for (Annotation annotation : annotations) {
            this.visitFixtureAnnotation(annotation, fixtureMethod);
        }
    }

    default public void visitFixtureAnnotation(T annotation, MethodInfo fixtureMethod) {
        throw new InvalidSpecException("@%s may not be applied to fixture methods").withArgs(annotation.annotationType().getSimpleName());
    }

    default public void visitFeatureAnnotations(List<T> annotations, FeatureInfo feature) {
        for (Annotation annotation : annotations) {
            this.visitFeatureAnnotation(annotation, feature);
        }
    }

    default public void visitFeatureAnnotation(T annotation, FeatureInfo feature) {
        throw new InvalidSpecException("@%s may not be applied to feature methods").withArgs(annotation.annotationType().getSimpleName());
    }

    default public void visitParameterAnnotation(T annotation, ParameterInfo parameter) {
        throw new InvalidSpecException("@%s may not be applied to parameters").withArgs(annotation.annotationType().getSimpleName());
    }

    default public void visitSpec(SpecInfo spec) {
    }
}

