/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import java.util.Iterator;
import java.util.List;
import org.spockframework.runtime.StoreProvider;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.IStore;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.Checks;
import org.spockframework.util.CollectionUtil;

public class MethodInvocation
implements IMethodInvocation {
    private final FeatureInfo feature;
    private final IterationInfo iteration;
    private final Object sharedInstance;
    private final Object instance;
    private final Object target;
    private final MethodInfo method;
    private Object[] arguments;
    private final Iterator<IMethodInterceptor> interceptors;
    private final StoreProvider storeProvider;

    public MethodInvocation(FeatureInfo feature, IterationInfo iteration, StoreProvider storeProvider, Object sharedInstance, Object instance, Object target, MethodInfo method, List<IMethodInterceptor> scopedInterceptors, Object[] arguments) {
        this.feature = feature;
        this.iteration = iteration;
        this.storeProvider = storeProvider;
        this.sharedInstance = sharedInstance;
        this.instance = instance;
        this.target = target;
        this.method = method;
        this.arguments = arguments;
        this.interceptors = scopedInterceptors.isEmpty() ? method.getInterceptors().iterator() : CollectionUtil.concat(scopedInterceptors, method.getInterceptors()).iterator();
    }

    @Override
    public SpecInfo getSpec() {
        return (SpecInfo)this.method.getParent();
    }

    @Override
    public FeatureInfo getFeature() {
        return this.feature;
    }

    @Override
    public IterationInfo getIteration() {
        return this.iteration;
    }

    @Override
    public Object getSharedInstance() {
        return this.sharedInstance;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public MethodInfo getMethod() {
        return this.method;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public IStore getStore(IStore.Namespace namespace) {
        return this.storeProvider.getStore(namespace);
    }

    @Override
    public void setArguments(Object[] arguments) {
        Checks.checkArgument(arguments.length != this.arguments.length, () -> "length of arguments array must not change from " + this.arguments.length + " to " + arguments.length);
        this.arguments = arguments;
    }

    @Override
    public void resolveArgument(int index, Object value) {
        Checks.checkState(this.arguments[index] == MethodInfo.MISSING_ARGUMENT, () -> "Parameter " + this.method.getParameters().get(index).getName() + " is already set");
        this.arguments[index] = value;
    }

    @Override
    public void proceed() throws Throwable {
        if (this.interceptors.hasNext()) {
            this.interceptors.next().intercept(this);
        } else {
            this.method.invoke(this.target, this.arguments);
        }
    }
}

