/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.Arrays;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionFailedWithExceptionError;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.WrongExceptionThrownError;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.TextPosition;
import spock.lang.FailsWith;

public class FailsWithInterceptor
implements IMethodInterceptor {
    private final FailsWith failsWith;

    public FailsWithInterceptor(FailsWith failsWith) {
        this.failsWith = failsWith;
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            if (this.checkException(t)) {
                return;
            }
            throw new WrongExceptionThrownError(this.failsWith.value(), t);
        }
        throw new WrongExceptionThrownError(this.failsWith.value(), null);
    }

    private boolean checkException(Throwable t) {
        if (this.matchesException(t)) {
            if (!this.failsWith.expectedMessage().isEmpty() && !this.failsWith.expectedMessage().equals(t.getMessage())) {
                throw new ConditionNotSatisfiedError(new Condition(Arrays.asList(t, t.getMessage(), this.failsWith.expectedMessage()), "e.value == expectedMessage", TextPosition.create(-1, -1), null, null, null));
            }
            return true;
        }
        return false;
    }

    private boolean matchesException(Throwable t) {
        return this.failsWith.value().isInstance(t) || t instanceof ConditionFailedWithExceptionError && this.failsWith.value().isInstance(t.getCause());
    }
}

