/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.reflect.Method;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.builtin.TimeoutConfiguration;
import org.spockframework.runtime.extension.builtin.TimeoutInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.Assert;
import spock.lang.Timeout;

public class GlobalTimeoutExtension
implements IGlobalExtension {
    private final TimeoutConfiguration timeoutConfiguration;
    private TimeoutInterceptor timeoutInterceptor;

    public GlobalTimeoutExtension(TimeoutConfiguration timeoutConfiguration) {
        this.timeoutConfiguration = Assert.notNull(timeoutConfiguration, "timeoutConfiguration is null", new Object[0]);
    }

    @Override
    public void start() {
        this.timeoutInterceptor = this.timeoutConfiguration.globalTimeout == null ? null : new TimeoutInterceptor(this.timeoutConfiguration.globalTimeout, this.timeoutConfiguration);
    }

    @Override
    public void visitSpec(SpecInfo spec) {
        if (this.timeoutInterceptor == null || ((Class)spec.getReflection()).isAnnotationPresent(Timeout.class)) {
            return;
        }
        Stream<MethodInfo> features = spec.getAllFeatures().stream().map(FeatureInfo::getFeatureMethod);
        Stream fixtures = this.timeoutConfiguration.applyGlobalTimeoutToFixtures ? StreamSupport.stream(spec.getAllFixtureMethods().spliterator(), false) : Stream.empty();
        Stream.concat(features, fixtures).filter(method -> !((Method)method.getReflection()).isAnnotationPresent(Timeout.class)).forEach(method -> method.addInterceptor(this.timeoutInterceptor));
    }
}

