/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.PendingFeatureBaseInterceptor;
import org.spockframework.runtime.extension.builtin.PendingFeatureSuccessfulError;

class PendingFeatureInterceptor
extends PendingFeatureBaseInterceptor
implements IMethodInterceptor {
    public PendingFeatureInterceptor(Class<? extends Throwable>[] handledExceptions, String reason, String annotationUsedByExtension) {
        super(handledExceptions, reason, annotationUsedByExtension);
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        try {
            invocation.proceed();
        }
        catch (TestAbortedException | PendingFeatureSuccessfulError e) {
            throw e;
        }
        catch (AssertionError e) {
            throw this.testAborted(((Throwable)((Object)e)).getStackTrace());
        }
        catch (Throwable e) {
            if (this.isExpected(e)) {
                throw this.testAborted(e.getStackTrace());
            }
            throw e;
        }
        throw this.featurePassedUnexpectedly(null);
    }
}

