/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.PendingFeatureBaseInterceptor;
import org.spockframework.runtime.extension.builtin.PendingFeatureSuccessfulError;

class PendingFeatureIterationInterceptor
extends PendingFeatureBaseInterceptor
implements IMethodInterceptor {
    public PendingFeatureIterationInterceptor(Class<? extends Throwable>[] expectedExceptions, String reason, String annotationUsed) {
        super(expectedExceptions, reason, annotationUsed);
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        AtomicReference<StackTraceElement[]> featureStackTrace = new AtomicReference<StackTraceElement[]>();
        AtomicBoolean success = new AtomicBoolean(false);
        AtomicBoolean expectedFailure = new AtomicBoolean(false);
        AtomicBoolean unexpectedFailure = new AtomicBoolean(false);
        invocation.getFeature().getFeatureMethod().addInterceptor(new InnerIterationInterceptor(featureStackTrace, success, expectedFailure, unexpectedFailure, this.expectedExceptions, this.reason, this.annotationUsed));
        invocation.proceed();
        if (!unexpectedFailure.get()) {
            if (expectedFailure.get()) {
                if (!invocation.getFeature().isReportIterations()) {
                    throw this.testAborted(featureStackTrace.get());
                }
            } else if (success.get()) {
                throw this.featurePassedUnexpectedly(featureStackTrace.get());
            }
        }
    }

    private static class InnerIterationInterceptor
    extends PendingFeatureBaseInterceptor
    implements IMethodInterceptor {
        private final AtomicReference<StackTraceElement[]> featureStackTrace;
        private final AtomicBoolean success;
        private final AtomicBoolean expectedFailure;
        private final AtomicBoolean unexpectedFailure;

        public InnerIterationInterceptor(AtomicReference<StackTraceElement[]> featureStackTrace, AtomicBoolean success, AtomicBoolean expectedFailure, AtomicBoolean unexpectedFailure, Class<? extends Throwable>[] expectedExceptions, String reason, String annotationUsed) {
            super(expectedExceptions, reason, annotationUsed);
            this.featureStackTrace = featureStackTrace;
            this.success = success;
            this.expectedFailure = expectedFailure;
            this.unexpectedFailure = unexpectedFailure;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            try {
                invocation.proceed();
                this.success.set(true);
            }
            catch (PendingFeatureSuccessfulError e) {
                throw e;
            }
            catch (TestAbortedException e) {
                this.featureStackTrace.compareAndSet(null, e.getStackTrace());
                throw e;
            }
            catch (AssertionError e) {
                this.featureStackTrace.set(((Throwable)((Object)e)).getStackTrace());
                this.expectedFailure.set(true);
                if (invocation.getFeature().isReportIterations()) {
                    throw this.testAborted(((Throwable)((Object)e)).getStackTrace());
                }
            }
            catch (Throwable e) {
                if (this.isExpected(e)) {
                    this.featureStackTrace.set(e.getStackTrace());
                    this.expectedFailure.set(true);
                    if (invocation.getFeature().isReportIterations()) {
                        throw this.testAborted(e.getStackTrace());
                    }
                }
                this.unexpectedFailure.set(true);
                throw e;
            }
        }
    }
}

