/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opentest4j.MultipleFailuresError;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.IStore;
import org.spockframework.runtime.extension.builtin.RetryBaseInterceptor;
import org.spockframework.runtime.model.MethodInfo;
import spock.lang.Retry;

public class RetryIterationInterceptor
extends RetryBaseInterceptor
implements IMethodInterceptor {
    private static final IStore.Namespace NAMESPACE = IStore.Namespace.create(RetryIterationInterceptor.class);
    private static final String ITERATION_STATE = "iterationState";

    public RetryIterationInterceptor(Retry retry, MethodInfo featureMethod) {
        super(retry);
        featureMethod.addInterceptor(new InnerRetryInterceptor(retry, this.condition));
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        IterationState iterationState = new IterationState();
        invocation.getStore(NAMESPACE).put(ITERATION_STATE, iterationState);
        for (int i = 0; i <= this.retry.count(); ++i) {
            iterationState.setRetryAttempt(i);
            invocation.proceed();
            if (iterationState.notFailed()) break;
            if (this.retry.delay() <= 0) continue;
            Thread.sleep(this.retry.delay());
        }
    }

    private class IterationState {
        private final AtomicBoolean finalIteration = new AtomicBoolean(false);
        private final List<Throwable> throwables = new CopyOnWriteArrayList<Throwable>();

        private IterationState() {
        }

        void resetFailures() {
            this.throwables.clear();
        }

        void setRetryAttempt(int retryAttempt) {
            this.finalIteration.set(retryAttempt == RetryIterationInterceptor.this.retry.count());
        }

        void failIteration(Throwable failure) {
            this.throwables.add(failure);
            if (this.finalIteration.get()) {
                throw new MultipleFailuresError("Retries exhausted", this.throwables);
            }
        }

        boolean notFailed() {
            return this.throwables.isEmpty();
        }
    }

    private class InnerRetryInterceptor
    extends RetryBaseInterceptor
    implements IMethodInterceptor {
        public InnerRetryInterceptor(Retry retry, Closure condition) {
            super(retry, condition);
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            IterationState iterationState = (IterationState)invocation.getStore(NAMESPACE).get(RetryIterationInterceptor.ITERATION_STATE);
            try {
                invocation.proceed();
                iterationState.resetFailures();
            }
            catch (Throwable e) {
                if (this.isExpected(invocation, e)) {
                    iterationState.failIteration(e);
                }
                throw e;
            }
        }
    }
}

