/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.IStore;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.ParameterInfo;
import org.spockframework.util.Checks;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.IThrowableBiConsumer;
import org.spockframework.util.IThrowableFunction;
import spock.lang.TempDir;

public class TempDirInterceptor
implements IMethodInterceptor {
    private static final IStore.Namespace NAMESPACE = IStore.Namespace.create(TempDirInterceptor.class);
    private static final String TEMP_DIR_PREFIX = "spock";
    private static final Pattern VALID_CHARS = Pattern.compile("[^a-zA-Z0-9_.-]++");
    private final IThrowableBiConsumer<IMethodInvocation, Path, Exception> valueSetter;
    private final String name;
    private final Path parentDir;
    private final TempDir annotation;
    private final TempDir.CleanupMode cleanupMode;

    private TempDirInterceptor(IThrowableBiConsumer<IMethodInvocation, Path, Exception> valueSetter, String name, Path parentDir, TempDir annotation, TempDir.CleanupMode cleanupMode) {
        this.valueSetter = valueSetter;
        this.name = name;
        this.parentDir = parentDir;
        this.annotation = annotation;
        this.cleanupMode = cleanupMode;
    }

    private String dirPrefix(IMethodInvocation invocation) {
        StringBuilder prefix = new StringBuilder(TEMP_DIR_PREFIX);
        prefix.append('_');
        String displayName = invocation.getIteration() == null ? invocation.getSpec().getDisplayName() : invocation.getIteration().getDisplayName();
        prefix.append(VALID_CHARS.matcher(displayName).replaceAll("_"));
        if (prefix.length() > 25) {
            prefix.setLength(25);
        }
        if (invocation.getIteration() != null) {
            prefix.append('_').append(invocation.getIteration().getIterationIndex());
        }
        return prefix.append('_').append(this.name).toString();
    }

    private Path generateTempDir(IMethodInvocation invocation) throws IOException {
        String prefix = this.dirPrefix(invocation);
        if (this.parentDir == null) {
            return Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        if (!Files.exists(this.parentDir, new LinkOption[0])) {
            Files.createDirectories(this.parentDir, new FileAttribute[0]);
        }
        return Files.createTempDirectory(this.parentDir, prefix, new FileAttribute[0]);
    }

    protected Path setUp(IMethodInvocation invocation) throws Exception {
        Path tempPath = this.generateTempDir(invocation);
        this.valueSetter.accept(invocation, tempPath);
        return tempPath;
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        Path path = this.setUp(invocation);
        TempDirContainer old = (TempDirContainer)invocation.getStore(NAMESPACE).put(System.identityHashCode(this.annotation), new TempDirContainer(path, this.cleanupMode, this.name));
        Checks.checkState(old == null, () -> "Replaced other value: " + old.path);
        invocation.proceed();
    }

    private static IThrowableFunction<Path, ?, Exception> createPathToTypeMapper(Class<?> targetType) {
        if (targetType.isAssignableFrom(Path.class) || Object.class.equals(targetType)) {
            return p -> p;
        }
        if (targetType.isAssignableFrom(File.class)) {
            return Path::toFile;
        }
        try {
            return arg_0 -> TempDirInterceptor.lambda$createPathToTypeMapper$2(targetType.getConstructor(Path.class), arg_0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Constructor<?> constructor = targetType.getConstructor(File.class);
                return path -> constructor.newInstance(path.toFile());
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new InvalidSpecException("@TempDir can only be used on File, Path, untyped field, or class that takes Path or File as single constructor argument.");
            }
        }
    }

    private static void deleteTempDir(Path tempPath) throws IOException {
        if (Files.notExists(tempPath, new LinkOption[0])) {
            return;
        }
        if (ResourceGroovyMethods.deleteDir((File)tempPath.toFile())) {
            return;
        }
        TempDirInterceptor.tryMakeWritable(tempPath);
        ResourceGroovyMethods.deleteDir((File)tempPath.toFile());
    }

    private static void tryMakeWritable(Path tempPath) throws IOException {
        Files.walkFileTree(tempPath, MakeWritableVisitor.INSTANCE);
    }

    static TempDirInterceptor forField(FieldInfo fieldInfo, Path parentDir, TempDir annotation, TempDir.CleanupMode cleanupMode) {
        IThrowableFunction<Path, ?, Exception> typeMapper = TempDirInterceptor.createPathToTypeMapper(fieldInfo.getType());
        return new TempDirInterceptor((invocation, path) -> fieldInfo.writeValue(invocation.getInstance(), typeMapper.apply((Path)path)), fieldInfo.getName(), parentDir, annotation, cleanupMode);
    }

    static TempDirInterceptor forParameter(ParameterInfo parameterInfo, Path parentDir, TempDir annotation, TempDir.CleanupMode cleanupMode) {
        IThrowableFunction<Path, ?, Exception> typeMapper = TempDirInterceptor.createPathToTypeMapper(((Parameter)parameterInfo.getReflection()).getType());
        return new TempDirInterceptor((invocation, path) -> invocation.resolveArgument(parameterInfo.getIndex(), typeMapper.apply((Path)path)), parameterInfo.getName(), parentDir, annotation, cleanupMode);
    }

    private static /* synthetic */ Object lambda$createPathToTypeMapper$2(Constructor rec$, Object xva$0) throws Exception {
        return rec$.newInstance(xva$0);
    }

    static class TempDirContainer
    implements AutoCloseable {
        private final Path path;
        private final TempDir.CleanupMode cleanupMode;
        private final String name;
        private volatile boolean failed = false;

        TempDirContainer(Path path, TempDir.CleanupMode cleanupMode, String name) {
            this.path = path;
            this.cleanupMode = cleanupMode;
            this.name = name;
        }

        void markFailed() {
            this.failed = true;
        }

        private void destroy(Path path) throws IOException {
            switch (this.cleanupMode) {
                case ON_SUCCESS: {
                    if (this.failed) {
                        System.err.printf("TempDir named '%s' with path '%s' not deleted because the test failed, please delete it manually after investigation.%n", this.name, path.toAbsolutePath());
                        return;
                    }
                }
                case ALWAYS: 
                case DEFAULT: {
                    TempDirInterceptor.deleteTempDir(path);
                    break;
                }
                case NEVER: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown cleanup mode: " + (Object)((Object)this.cleanupMode));
                }
            }
        }

        @Override
        public void close() {
            try {
                this.destroy(this.path);
            }
            catch (IOException e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
    }

    static class FailureTracker
    implements IMethodInterceptor {
        private final TempDir annotation;

        FailureTracker(TempDir annotation) {
            this.annotation = annotation;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            TempDirContainer tempDirContainer = invocation.getStore(NAMESPACE).get(System.identityHashCode(this.annotation), TempDirContainer.class);
            try {
                invocation.proceed();
            }
            catch (Throwable t) {
                tempDirContainer.markFailed();
                throw t;
            }
        }
    }

    private static class MakeWritableVisitor
    extends SimpleFileVisitor<Path> {
        static MakeWritableVisitor INSTANCE = new MakeWritableVisitor();

        private MakeWritableVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            file.toFile().setWritable(true);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            dir.toFile().setWritable(true);
            return FileVisitResult.CONTINUE;
        }
    }
}

