/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.spockframework.util.InternalSpockError;

public abstract class Assert {
    @Contract(value="null -> fail")
    public static <T> T notNull(T obj) {
        return Assert.notNull(obj, "argument is null", new Object[0]);
    }

    @Contract(value="null, _, _ -> fail")
    public static <T> T notNull(T obj, String msg, Object ... values) {
        if (obj == null) {
            throw new InternalSpockError(String.format(msg, values));
        }
        return obj;
    }

    @Contract(value="false -> fail")
    public static void that(boolean condition) {
        Assert.that(condition, "internal error", new Object[0]);
    }

    @Contract(value="false, _, _ -> fail")
    public static void that(boolean condition, String msg, Object ... values) {
        if (!condition) {
            throw new InternalSpockError(String.format(msg, values));
        }
    }

    public static void that(boolean condition, Supplier<String> msgSupplier) {
        if (!condition) {
            throw new InternalSpockError(msgSupplier.get());
        }
    }

    @Contract(value="_, _ -> fail")
    public static void fail(String msg, Object ... values) {
        Assert.that(false, msg, values);
    }
}

