/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.spockframework.util.InternalSpockError;

public abstract class StringMessagePrintStream
extends PrintStream {
    public StringMessagePrintStream() {
        super(new ByteArrayOutputStream(0));
    }

    @Override
    public void write(int b) {
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(new byte[]{(byte)b}));
        try {
            this.printed(String.valueOf((char)reader.read()));
        }
        catch (IOException e) {
            throw new InternalSpockError(e);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        byte[] source = new byte[len];
        System.arraycopy(buf, off, source, 0, len);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(source));
        try {
            char[] target = new char[len];
            int actualLen = reader.read(target, 0, len);
            this.printed(String.valueOf(target, 0, actualLen));
        }
        catch (IOException e) {
            throw new InternalSpockError(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void print(boolean b) {
        this.printed(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.printed(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.printed(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.printed(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.printed(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.printed(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.printed(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        this.printed(String.valueOf(s));
    }

    @Override
    public void print(Object obj) {
        this.printed(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.printed("\n");
    }

    @Override
    public void println(boolean x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(char x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(int x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(long x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(float x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(double x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(char[] x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(String x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public void println(Object x) {
        this.printed(String.valueOf(x) + "\n");
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.printed(String.valueOf(csq));
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence seq = csq == null ? "null" : csq;
        this.printed(seq.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    protected abstract void printed(String var1);
}

