/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TextUtil {
    private static final Pattern LOWER_UPPER = Pattern.compile("([^\\p{Upper}]*)(\\p{Upper}*)");

    public static String repeatChar(char ch, int times) {
        char[] chars = new char[times];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static int getIndent(String line) {
        int i;
        for (i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
        }
        return i;
    }

    public static int getIndent(List<String> lines) {
        int result = Integer.MAX_VALUE;
        for (String line : lines) {
            int indent = TextUtil.getIndent(line);
            if (indent >= result) continue;
            result = indent;
        }
        return result;
    }

    public static String changeSubsequentIndent(String block, int delta, String lineSeparator) {
        List<String> lines = Arrays.asList(block.split(lineSeparator));
        if (lines.size() == 1) {
            return block;
        }
        TextUtil.changeIndent(lines.subList(1, lines.size()), delta);
        return TextUtil.join(lineSeparator, lines);
    }

    public static String changeIndent(String line, int delta) {
        return delta > 0 ? TextUtil.repeatChar(' ', delta) + line : line.substring(-delta);
    }

    public static void changeIndent(List<String> lines, int delta) {
        if (delta == 0) {
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            lines.set(i, TextUtil.changeIndent(lines.get(i), delta));
        }
    }

    public static String erase(String line, int from, int to) {
        return line.substring(0, from) + TextUtil.repeatChar(' ', to - from) + line.substring(to);
    }

    public static String erase(String line, int from) {
        return TextUtil.erase(line, from, line.length());
    }

    public static int getTrailingWhitespace(String line) {
        return line.length() - line.trim().length() - TextUtil.getIndent(line);
    }

    public static String join(String separator, List<?> objects) {
        StringBuilder builder = new StringBuilder();
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            builder.append(objects.get(i));
            if (i == size - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String join(String separator, Object ... objects) {
        return TextUtil.join(separator, Arrays.asList(objects));
    }

    public static int countOccurrences(String text, char symbol) {
        int result = 0;
        for (char ch : text.toCharArray()) {
            if (ch != symbol) continue;
            ++result;
        }
        return result;
    }

    public static String escape(char ch) {
        if (ch == '\\') {
            return "\\\\";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\b') {
            return "\\b";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\f') {
            return "\\f";
        }
        return String.valueOf(ch);
    }

    public static String escape(CharSequence seq) {
        StringBuilder builder = new StringBuilder(seq.length() * 3 / 2);
        for (int i = 0; i < seq.length(); ++i) {
            builder.append(TextUtil.escape(seq.charAt(i)));
        }
        return builder.toString();
    }

    public static String printStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static long longHashCode(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    public static String camelCaseToConstantCase(String value) {
        if (value == null || "".equals(value)) {
            return value;
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = LOWER_UPPER.matcher(value);
        while (matcher.find()) {
            String lowers = matcher.group(1);
            String uppers = matcher.group(2);
            if (uppers.length() == 0) {
                result.append(lowers.toUpperCase(Locale.ROOT));
                continue;
            }
            if (lowers.length() > 0) {
                result.append(lowers.toUpperCase(Locale.ROOT));
                result.append('_');
            }
            if (uppers.length() > 1 && !matcher.hitEnd()) {
                result.append(uppers.substring(0, uppers.length() - 1));
                result.append('_');
                result.append(uppers.charAt(uppers.length() - 1));
                continue;
            }
            result.append(uppers);
        }
        return result.toString();
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toUpperCase(str.charAt(0)));
        builder.append(str.substring(1));
        return builder.toString();
    }
}

