/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import org.spockframework.util.GroovyReleaseInfo;
import org.spockframework.util.IncompatibleGroovyVersionException;
import org.spockframework.util.SpockReleaseInfo;

public class VersionChecker {
    static final String DISABLE_GROOVY_VERSION_CHECK_PROPERTY_NAME = "spock.iKnowWhatImDoing.disableGroovyVersionCheck";
    private static final boolean compatibleGroovyVersion = SpockReleaseInfo.isCompatibleGroovyVersion(GroovyReleaseInfo.getVersion());

    public void checkGroovyVersion(String whoIsChecking) {
        if (!this.isCompatibleGroovyVersion()) {
            if (this.isVersionCheckDisabled()) {
                System.err.println(String.format("Executing Spock %s with NOT compatible Groovy version %s due to set %s system property. This is unsupported and may result in weird runtime errors!", SpockReleaseInfo.getVersion(), GroovyReleaseInfo.getVersion(), DISABLE_GROOVY_VERSION_CHECK_PROPERTY_NAME));
            } else {
                throw new IncompatibleGroovyVersionException(String.format("The Spock %s cannot execute because Spock %s is not compatible with Groovy %s. For more information (including enforce mode), see https://docs.spockframework.org (section 'Known Issues').\nSpock artifact: %s\nGroovy artifact: %s", whoIsChecking, SpockReleaseInfo.getVersion(), GroovyReleaseInfo.getVersion(), SpockReleaseInfo.getArtifactPath(), GroovyReleaseInfo.getArtifactPath()));
            }
        }
    }

    boolean isCompatibleGroovyVersion() {
        return compatibleGroovyVersion;
    }

    private boolean isVersionCheckDisabled() {
        return "true".equals(System.getProperty(DISABLE_GROOVY_VERSION_CHECK_PROPERTY_NAME));
    }
}

