/*
 * Decompiled with CFR 0.152.
 */
package spock.lang;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.util.Assert;
import org.spockframework.util.Checks;
import org.spockframework.util.IoUtil;

public class Snapshotter {
    private final Store snapshotStore;
    private Wrapper wrapper = Wrapper.NOOP;
    private Function<String, String> normalizer = StringGroovyMethods::normalize;

    public Snapshotter(Store snapshotStore) {
        this.snapshotStore = Checks.notNull(snapshotStore, () -> "snapshotStore is null");
    }

    protected Store getSnapshotStore() {
        return this.snapshotStore;
    }

    protected String loadSnapshot(String snapshotId) {
        Checks.notNull(snapshotId, () -> "snapshotId is null");
        return this.getSnapshotStore().loadSnapshot(snapshotId).map(this.wrapper::unwrap).orElse("<Missing Snapshot>");
    }

    protected void saveSnapshot(String snapshotId, String value) {
        Checks.notNull(snapshotId, () -> "snapshotId is null");
        Checks.notNull(value, () -> "value is null");
        this.snapshotStore.saveSnapshot(snapshotId, this.wrapper.wrap(value));
    }

    protected void saveActual(String snapshotId, String value) {
        Checks.notNull(snapshotId, () -> "snapshotId is null");
        Checks.notNull(value, () -> "value is null");
        this.snapshotStore.saveActual(snapshotId, this.wrapper.wrap(value));
    }

    protected void deleteActual(String snapshotId) {
        Checks.notNull(snapshotId, () -> "snapshotId is null");
        this.snapshotStore.deleteActual(snapshotId);
    }

    public Snapshotter wrappedAs(Wrapper wrapper) {
        Checks.notNull(wrapper, () -> "wrapper is null");
        this.wrapper = wrapper;
        return this;
    }

    public Snapshotter normalizedWith(Function<String, String> normalizer) {
        Checks.notNull(normalizer, () -> "normalizer is null");
        this.normalizer = normalizer;
        return this;
    }

    public Snapshot assertThat(String value) {
        Checks.notNull(value, () -> "value is null");
        return new Snapshot(value);
    }

    public String toString() {
        return "Snapshotter";
    }

    public static final class Store {
        private final IterationInfo iterationInfo;
        private final boolean updateSnapshots;
        private final boolean writeActualContents;
        private final String extension;
        private final Charset charset;
        private final Path specPath;

        public Store(IterationInfo iterationInfo, Path rootPath, boolean updateSnapshots, boolean writeActualContents, String extension, Charset charset) {
            this.iterationInfo = Assert.notNull(iterationInfo);
            this.updateSnapshots = Assert.notNull(updateSnapshots);
            this.writeActualContents = writeActualContents;
            this.extension = Assert.notNull(extension);
            this.charset = Assert.notNull(charset);
            Class specClass = (Class)((SpecInfo)iterationInfo.getFeature().getParent()).getBottomSpec().getReflection();
            this.specPath = rootPath.resolve(specClass.getPackage().getName().replace('.', '/')).resolve(specClass.getSimpleName().replace('$', '/'));
        }

        private static String calculateSafeUniqueName(String extension, IterationInfo iterationInfo, String snapshotId) {
            Checks.checkArgument(snapshotId.length() <= 100, () -> String.format("'snapshotId' is too long, only 100 characters are allowed, but was %d: %s", snapshotId.length(), snapshotId));
            FeatureInfo feature = iterationInfo.getFeature();
            String safeName = Store.sanitize(feature.getName());
            String featureId = ((Method)feature.getFeatureMethod().getReflection()).getName().substring("$spock_feature_".length());
            String iterationIndex = feature.isParameterized() ? String.format(Locale.ROOT, "-[%d]", iterationInfo.getIterationIndex()) : "";
            String snapshotIdSuffix = snapshotId.isEmpty() ? "" : "-" + Store.sanitize(snapshotId);
            int uniqueSuffixLength = 1 + featureId.length() + 1 + extension.length() + iterationIndex.length() + snapshotIdSuffix.length();
            if (safeName.length() + uniqueSuffixLength > 250) {
                safeName = safeName.substring(0, 250 - uniqueSuffixLength);
                return String.format(Locale.ROOT, "%s%s-%s%s.%s", safeName, snapshotIdSuffix, featureId, iterationIndex, extension);
            }
            return String.format(Locale.ROOT, "%s%s%s.%s", safeName, snapshotIdSuffix, iterationIndex, extension);
        }

        private static String sanitize(String snapshotId) {
            return Assert.notNull(snapshotId).replaceAll("[^a-zA-Z0-9]", "_");
        }

        public Optional<String> loadSnapshot(String snapshotId) {
            Assert.notNull(snapshotId);
            Path snapshotPath = this.specPath.resolve(Store.calculateSafeUniqueName(this.extension, this.iterationInfo, snapshotId));
            if (Files.isRegularFile(snapshotPath, new LinkOption[0])) {
                try {
                    return Optional.of(IoUtil.getText(snapshotPath, this.charset));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failure while trying to load Snapshot: " + snapshotPath, e);
                }
            }
            return Optional.empty();
        }

        public void saveSnapshot(String snapshotId, String value) {
            Assert.notNull(snapshotId);
            Assert.notNull(value);
            try {
                Path snapshotPath = this.specPath.resolve(Store.calculateSafeUniqueName(this.extension, this.iterationInfo, snapshotId));
                Files.createDirectories(this.specPath, new FileAttribute[0]);
                IoUtil.writeText(snapshotPath, value, this.charset);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not create directories", e);
            }
        }

        public void saveActual(String snapshotId, String value) {
            Assert.notNull(snapshotId);
            Assert.notNull(value);
            try {
                Path snapshotPath = this.specPath.resolve(Store.calculateSafeUniqueName(this.extension + ".actual", this.iterationInfo, snapshotId));
                Files.createDirectories(this.specPath, new FileAttribute[0]);
                IoUtil.writeText(snapshotPath, value, this.charset);
                System.err.println("Snapshot actual value has been saved to: " + snapshotPath.toAbsolutePath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not create directories", e);
            }
        }

        public void deleteActual(String snapshotId) {
            Assert.notNull(snapshotId);
            try {
                Path snapshotPath = this.specPath.resolve(Store.calculateSafeUniqueName(this.extension + ".actual", this.iterationInfo, snapshotId));
                Files.deleteIfExists(snapshotPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not delete file", e);
            }
        }

        public boolean isUpdateSnapshots() {
            return this.updateSnapshots;
        }

        public boolean isWriteActualContents() {
            return this.writeActualContents;
        }
    }

    private static class NoopWrapper
    implements Wrapper {
        private NoopWrapper() {
        }

        @Override
        public String wrap(String string) {
            return string;
        }

        @Override
        public String unwrap(String string) {
            return string;
        }
    }

    public static class PrefixSuffixWrapper
    implements Wrapper {
        private final String prefix;
        private final String suffix;

        private PrefixSuffixWrapper(String prefix, String suffix) {
            this.prefix = Checks.notNull(prefix, () -> "prefix is null");
            this.suffix = Checks.notNull(suffix, () -> "suffix is null");
        }

        public static PrefixSuffixWrapper of(String prefix, String suffix) {
            return new PrefixSuffixWrapper(prefix, suffix);
        }

        public static PrefixSuffixWrapper asciiDocSample(String prefix, String suffix) {
            Checks.notNull(prefix, () -> "prefix is null");
            Checks.notNull(suffix, () -> "suffix is null");
            return new PrefixSuffixWrapper(prefix + "\n/*--------- tag::snapshot[] ---------*/\n", "\n/*--------- end::snapshot[] ---------*/\n" + suffix);
        }

        @Override
        public String wrap(String value) {
            return this.prefix + value + this.suffix;
        }

        @Override
        public String unwrap(String value) {
            Checks.notNull(value, () -> "value is null");
            if (!value.startsWith(this.prefix) || !value.endsWith(this.suffix)) {
                System.err.printf("Cannot unwrap because prefix matches=%s, prefix matches=%s%n", value.startsWith(this.prefix), value.endsWith(this.suffix));
                return value;
            }
            return value.substring(this.prefix.length(), value.length() - this.suffix.length());
        }
    }

    public static interface Wrapper {
        public static final Wrapper NOOP = new NoopWrapper();

        public String wrap(String var1);

        public String unwrap(String var1);
    }

    public class Snapshot {
        private final String value;

        private Snapshot(String value) {
            this.value = (String)Checks.notNull(Snapshotter.this.normalizer.apply(Checks.notNull(value, () -> "value is null")), () -> "normalizer returned null value");
        }

        public void matchesSnapshot() {
            this.matchesSnapshot("");
        }

        public void matchesSnapshot(String snapshotId) {
            this.matchesSnapshot(snapshotId, (expected, actual) -> {
                if (!Objects.equals(expected, actual)) {
                    throw new ConditionNotSatisfiedError(new Condition(Arrays.asList(this.value, expected), "value == snapshotValue", TextPosition.create(-1, -1), null, null, null));
                }
            });
        }

        public void matchesSnapshot(BiConsumer<String, String> snapshotMatcher) {
            this.matchesSnapshot("", snapshotMatcher);
        }

        public void matchesSnapshot(String snapshotId, BiConsumer<String, String> snapshotMatcher) {
            Checks.notNull(snapshotId, () -> "snapshotId is null");
            Checks.notNull(snapshotMatcher, () -> "snapshotMatcher is null");
            String snapshotValue = Snapshotter.this.loadSnapshot(snapshotId);
            try {
                snapshotMatcher.accept(snapshotValue, this.value);
                if (Snapshotter.this.snapshotStore.isWriteActualContents()) {
                    Snapshotter.this.deleteActual(snapshotId);
                }
            }
            catch (AssertionError e) {
                if (Snapshotter.this.snapshotStore.isUpdateSnapshots()) {
                    Snapshotter.this.saveSnapshot(snapshotId, this.value);
                }
                if (Snapshotter.this.snapshotStore.isWriteActualContents()) {
                    Snapshotter.this.saveActual(snapshotId, this.value);
                }
                throw e;
            }
        }

        public String toString() {
            return "Snapshot";
        }
    }
}

