/*
 * Decompiled with CFR 0.152.
 */
package spock.util.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.function.BiFunction;

public class MutableClock
extends Clock {
    private final ZoneId zone;
    private Instant instant;
    private TemporalAmount changeAmount;

    public MutableClock() {
        this(Instant.now(), ZoneId.systemDefault());
    }

    public MutableClock(Instant instant) {
        this(instant, ZoneId.systemDefault());
    }

    public MutableClock(ZoneId zone) {
        this(Instant.now(), zone);
    }

    public MutableClock(Instant instant, ZoneId zone) {
        this(instant, zone, Duration.ofSeconds(1L));
    }

    public MutableClock(Instant instant, ZoneId zone, TemporalAmount changeAmount) {
        this.instant = Objects.requireNonNull(instant, "instant may not be null");
        this.zone = Objects.requireNonNull(zone, "zone may not be null");
        this.changeAmount = Objects.requireNonNull(changeAmount, "changeAmount may not be null");
    }

    public MutableClock(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public MutableClock withZone(ZoneId zone) {
        return new MutableClock(this.instant, zone, this.changeAmount);
    }

    @Override
    public Instant instant() {
        return this.instant;
    }

    public void setChangeAmount(TemporalAmount changeAmount) {
        this.changeAmount = Objects.requireNonNull(changeAmount, "changeAmount may not be null");
    }

    public void setInstant(Instant instant) {
        this.instant = Objects.requireNonNull(instant, "instant may not be null");
    }

    public MutableClock modify(BiFunction<Instant, ZoneId, Instant> modification) {
        this.instant = modification.apply(this.instant, this.zone);
        return this;
    }

    public MutableClock plus(TemporalAmount amount) {
        this.instant = this.instant.plus(amount);
        return this;
    }

    public MutableClock minus(TemporalAmount amount) {
        this.instant = this.instant.minus(amount);
        return this;
    }

    public MutableClock adjust(TemporalAdjuster adjuster) {
        this.instant = ZonedDateTime.now(this).with(adjuster).toInstant();
        return this;
    }

    public MutableClock next() {
        return this.plus(this.changeAmount);
    }

    public MutableClock previous() {
        return this.minus(this.changeAmount);
    }

    public String toString() {
        return "MutableClock{zone=" + this.zone + ", instant=" + this.instant + ", changeAmount=" + this.changeAmount + '}';
    }
}

