/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.SpringSpy;
import org.spockframework.spring.mock.FieldDefinition;
import org.spockframework.util.Assert;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;
import spock.mock.DetachedMockFactory;

class SpyDefinition
extends FieldDefinition {
    private final SpringSpy annotation;

    SpyDefinition(FieldInfo fieldInfo) {
        super(fieldInfo);
        this.validate();
        this.annotation = (SpringSpy)fieldInfo.getAnnotation(SpringSpy.class);
    }

    private void validate() {
        FieldInfo fieldInfo = this.getFieldInfo();
        Assert.that((boolean)fieldInfo.isAnnotationPresent(SpringSpy.class), (String)"SpringBean annotation is required for this field: '%s.%s:%d' ", (Object[])new Object[]{((SpecInfo)fieldInfo.getParent()).getName(), fieldInfo.getName(), fieldInfo.getLine()});
        if (fieldInfo.hasInitializer()) {
            throw new SpringExtensionException(String.format("Field '%s.%s:%d' may not have an initializer.", ((SpecInfo)fieldInfo.getParent()).getName(), fieldInfo.getName(), fieldInfo.getLine()));
        }
        if (Object.class.equals((Object)fieldInfo.getType())) {
            throw new SpringExtensionException(String.format("Field '%s.%s:%d' must use a concrete type, not def or Object.", ((SpecInfo)fieldInfo.getParent()).getName(), fieldInfo.getName(), fieldInfo.getLine()));
        }
    }

    ResolvableType getTypeToSpy() {
        return this.resolvableType;
    }

    @Override
    public String getName() {
        return this.annotation.name();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.getTypeToSpy());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpyDefinition other = (SpyDefinition)obj;
        boolean result = super.equals(obj);
        result = result && ObjectUtils.nullSafeEquals((Object)this.getTypeToSpy(), (Object)other.getTypeToSpy());
        return result;
    }

    Object createSpy(String beanName, Object bean) {
        return new DetachedMockFactory().Spy(bean);
    }
}

