/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.xml;

import java.util.Collections;
import java.util.Locale;
import org.spockframework.mock.MockNature;
import org.springframework.beans.factory.FactoryBean;
import spock.mock.DetachedMockFactory;

public class SpockMockFactoryBean<T>
implements FactoryBean<T> {
    private final Class<T> targetClass;
    private String name;
    private String mockNature = MockNature.MOCK.name();
    private T instance;

    public SpockMockFactoryBean(Class<T> targetClass) {
        this.targetClass = targetClass;
    }

    public T getObject() throws Exception {
        if (this.instance == null) {
            MockNature nature = MockNature.valueOf((String)this.mockNature.toUpperCase(Locale.ROOT));
            this.instance = new DetachedMockFactory().createMock(this.name, this.targetClass, nature, Collections.emptyMap());
        }
        return this.instance;
    }

    public Class<?> getObjectType() {
        return this.targetClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMockNature() {
        return this.mockNature;
    }

    public void setMockNature(String mockNature) {
        this.mockNature = mockNature;
    }
}

