/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;

public class GenericParameterService {
    private static final List<Class<?>> FILE_TYPES = new ArrayList();
    private final Optional<DelegatingMethodParameterCustomizer> optionalDelegatingMethodParameterCustomizer;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericParameterService.class);
    private final PropertyResolverUtils propertyResolverUtils;

    public GenericParameterService(PropertyResolverUtils propertyResolverUtils, Optional<DelegatingMethodParameterCustomizer> optionalDelegatingMethodParameterCustomizer) {
        this.propertyResolverUtils = propertyResolverUtils;
        this.optionalDelegatingMethodParameterCustomizer = optionalDelegatingMethodParameterCustomizer;
    }

    public static void addFileType(Class<?> ... classes) {
        FILE_TYPES.addAll(Arrays.asList(classes));
    }

    public static boolean isFile(Class type) {
        return FILE_TYPES.stream().anyMatch(clazz -> clazz.isAssignableFrom(type));
    }

    public static io.swagger.v3.oas.models.parameters.Parameter mergeParameter(List<io.swagger.v3.oas.models.parameters.Parameter> existingParamDoc, io.swagger.v3.oas.models.parameters.Parameter paramCalcul) {
        io.swagger.v3.oas.models.parameters.Parameter result = paramCalcul;
        if (paramCalcul != null && paramCalcul.getName() != null) {
            String name = paramCalcul.getName();
            io.swagger.v3.oas.models.parameters.Parameter paramDoc = existingParamDoc.stream().filter(p -> name.equals(p.getName())).findAny().orElse(null);
            if (paramDoc != null) {
                GenericParameterService.mergeParameter(paramCalcul, paramDoc);
                result = paramDoc;
            } else {
                existingParamDoc.add(result);
            }
        }
        return result;
    }

    private static void mergeParameter(io.swagger.v3.oas.models.parameters.Parameter paramCalcul, io.swagger.v3.oas.models.parameters.Parameter paramDoc) {
        if (StringUtils.isBlank((CharSequence)paramDoc.getDescription())) {
            paramDoc.setDescription(paramCalcul.getDescription());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.getIn())) {
            paramDoc.setIn(paramCalcul.getIn());
        }
        if (paramDoc.getExample() == null) {
            paramDoc.setExample(paramCalcul.getExample());
        }
        if (paramDoc.getDeprecated() == null) {
            paramDoc.setDeprecated(paramCalcul.getDeprecated());
        }
        if (paramDoc.getRequired() == null) {
            paramDoc.setRequired(paramCalcul.getRequired());
        }
        if (paramDoc.getAllowEmptyValue() == null) {
            paramDoc.setAllowEmptyValue(paramCalcul.getAllowEmptyValue());
        }
        if (paramDoc.getAllowReserved() == null) {
            paramDoc.setAllowReserved(paramCalcul.getAllowReserved());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.get$ref())) {
            paramDoc.set$ref(paramDoc.get$ref());
        }
        if (paramDoc.getSchema() == null && paramDoc.getContent() == null) {
            paramDoc.setSchema(paramCalcul.getSchema());
        }
        if (paramDoc.getExamples() == null) {
            paramDoc.setExamples(paramCalcul.getExamples());
        }
        if (paramDoc.getExtensions() == null) {
            paramDoc.setExtensions(paramCalcul.getExtensions());
        }
        if (paramDoc.getStyle() == null) {
            paramDoc.setStyle(paramCalcul.getStyle());
        }
        if (paramDoc.getExplode() == null) {
            paramDoc.setExplode(paramCalcul.getExplode());
        }
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParameterFromDoc(Parameter parameterDoc, Components components, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
            parameter.setDescription(this.propertyResolverUtils.resolve(parameterDoc.description()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.name())) {
            parameter.setName(this.propertyResolverUtils.resolve(parameterDoc.name()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.in().toString())) {
            parameter.setIn(parameterDoc.in().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.example())) {
            try {
                parameter.setExample((Object)Json.mapper().readTree(parameterDoc.example()));
            }
            catch (IOException e) {
                parameter.setExample((Object)parameterDoc.example());
            }
        }
        if (parameterDoc.deprecated()) {
            parameter.setDeprecated(Boolean.valueOf(parameterDoc.deprecated()));
        }
        if (parameterDoc.required()) {
            parameter.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        if (parameterDoc.allowEmptyValue()) {
            parameter.setAllowEmptyValue(Boolean.valueOf(parameterDoc.allowEmptyValue()));
        }
        if (parameterDoc.allowReserved()) {
            parameter.setAllowReserved(Boolean.valueOf(parameterDoc.allowReserved()));
        }
        if (parameterDoc.content().length > 0) {
            Optional optionalContent = AnnotationsUtils.getContent((Content[])parameterDoc.content(), null, null, null, (Components)components, (JsonView)jsonView);
            optionalContent.ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setContent(arg_0));
        } else {
            this.setSchema(parameterDoc, components, jsonView, parameter);
        }
        this.setExamples(parameterDoc, parameter);
        this.setExtensions(parameterDoc, parameter);
        this.setParameterStyle(parameter, parameterDoc);
        this.setParameterExplode(parameter, parameterDoc);
        return parameter;
    }

    private void setSchema(Parameter parameterDoc, Components components, JsonView jsonView, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.ref())) {
            parameter.$ref(parameterDoc.ref());
        } else {
            Schema schema = null;
            try {
                schema = AnnotationsUtils.getSchema((io.swagger.v3.oas.annotations.media.Schema)parameterDoc.schema(), null, (boolean)false, (Class)parameterDoc.schema().implementation(), (Components)components, (JsonView)jsonView).orElse(null);
            }
            catch (Exception e) {
                LOGGER.warn("Graceful exception occurred", (Throwable)e);
            }
            if (schema == null) {
                schema = AnnotationsUtils.getArraySchema((io.swagger.v3.oas.annotations.media.ArraySchema)parameterDoc.array(), (Components)components, (JsonView)jsonView).orElse(null);
            }
            parameter.setSchema(schema);
        }
    }

    Schema calculateSchema(Components components, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo, JsonView jsonView) {
        Schema schemaN;
        String paramName = parameterInfo.getpName();
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        if (parameterInfo.getParameterModel() == null || parameterInfo.getParameterModel().getSchema() == null) {
            Type type = ReturnTypeParser.getType(methodParameter);
            schemaN = SpringDocAnnotationsUtils.extractSchema(components, type, jsonView, methodParameter.getParameterAnnotations());
        } else {
            schemaN = parameterInfo.getParameterModel().getSchema();
        }
        if (requestBodyInfo != null) {
            schemaN = this.calculateRequestBodySchema(components, parameterInfo, requestBodyInfo, schemaN, paramName);
        }
        return schemaN;
    }

    private Schema calculateRequestBodySchema(Components components, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo, Schema schemaN, String paramName) {
        if (schemaN != null && StringUtils.isEmpty((CharSequence)schemaN.getDescription()) && parameterInfo.getParameterModel() != null) {
            String description = parameterInfo.getParameterModel().getDescription();
            if (schemaN.get$ref() != null && schemaN.get$ref().contains("#/components/schemas/")) {
                String key = schemaN.get$ref().substring(21);
                Schema existingSchema = (Schema)components.getSchemas().get(key);
                if (!StringUtils.isEmpty((CharSequence)description)) {
                    existingSchema.setDescription(description);
                }
            } else {
                schemaN.setDescription(description);
            }
        }
        if (requestBodyInfo.getMergedSchema() != null) {
            requestBodyInfo.getMergedSchema().addProperties(paramName, schemaN);
            schemaN = requestBodyInfo.getMergedSchema();
        } else if (schemaN instanceof FileSchema || schemaN instanceof ArraySchema && ((ArraySchema)schemaN).getItems() instanceof FileSchema) {
            schemaN = new ObjectSchema().addProperties(paramName, schemaN);
            requestBodyInfo.setMergedSchema(schemaN);
        } else {
            requestBodyInfo.addProperties(paramName, schemaN);
        }
        return schemaN;
    }

    private void setExamples(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        HashMap exampleMap = new HashMap();
        if (parameterDoc.examples().length == 1 && StringUtils.isBlank((CharSequence)parameterDoc.examples()[0].name())) {
            Optional exampleOptional = AnnotationsUtils.getExample((ExampleObject)parameterDoc.examples()[0]);
            exampleOptional.ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setExample(arg_0));
        } else {
            for (ExampleObject exampleObject : parameterDoc.examples()) {
                AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
            }
        }
        if (exampleMap.size() > 0) {
            parameter.setExamples(exampleMap);
        }
    }

    private void setExtensions(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameterDoc.extensions().length > 0) {
            Map extensionMap = AnnotationsUtils.getExtensions((Extension[])parameterDoc.extensions());
            extensionMap.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).addExtension(arg_0, arg_1));
        }
    }

    private void setParameterExplode(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (this.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private void setParameterStyle(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    private boolean isExplodable(Parameter p) {
        io.swagger.v3.oas.annotations.media.Schema schema = p.schema();
        io.swagger.v3.oas.annotations.media.ArraySchema arraySchema = p.array();
        boolean explode = true;
        Class implementation = schema.implementation();
        if (!(implementation != Void.class || schema.type().equals("object") || schema.type().equals("array") || AnnotationsUtils.hasArrayAnnotation((io.swagger.v3.oas.annotations.media.ArraySchema)arraySchema))) {
            explode = false;
        }
        return explode;
    }

    public boolean isFile(MethodParameter methodParameter) {
        if (methodParameter.getGenericParameterType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)methodParameter.getGenericParameterType();
            return this.isFile(parameterizedType);
        }
        Class type = methodParameter.getParameterType();
        return GenericParameterService.isFile(type);
    }

    public Optional<DelegatingMethodParameterCustomizer> getDelegatingMethodParameterCustomizer() {
        return this.optionalDelegatingMethodParameterCustomizer;
    }

    private boolean isFile(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getActualTypeArguments()[0];
        Class fileClass = ResolvableType.forType((Type)type).getRawClass();
        if (fileClass != null && GenericParameterService.isFile(fileClass)) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            return MultipartFile.class.getName().equals(upperBounds[0].getTypeName());
        }
        return false;
    }

    public PropertyResolverUtils getPropertyResolverUtils() {
        return this.propertyResolverUtils;
    }

    static {
        FILE_TYPES.add(MultipartFile.class);
        FILE_TYPES.add(Resource.class);
    }
}

