/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@NotNull
public class Pageable {
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) int page;
    @NotNull
    @Min(value=1L)
    @Max(value=2000L)
    private @NotNull @Min(value=1L) @Max(value=2000L) int size;
    private List<String> sort;

    public Pageable(@NotNull @Min(value=0L) @NotNull @Min(value=0L) int page, @NotNull @Min(value=1L) @Max(value=2000L) @NotNull @Min(value=1L) @Max(value=2000L) int size, List<String> sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<String> getSort() {
        return this.sort;
    }

    public void setSort(List<String> sort) {
        if (sort == null) {
            this.sort.clear();
        }
        this.sort = sort;
    }

    public void addSort(String sort) {
        this.sort.add(sort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pageable pageable = (Pageable)o;
        return this.page == pageable.page && this.size == pageable.size && Objects.equals(this.sort, pageable.sort);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.size, this.sort);
    }

    public String toString() {
        return "Pageable{page=" + this.page + ", size=" + this.size + ", sort=" + this.sort + '}';
    }
}

