/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.hateoas;

import io.swagger.v3.core.util.Json;
import java.util.Optional;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.hateoas.HateoasHalProvider;
import org.springdoc.hateoas.converters.CollectionModelContentConverter;
import org.springdoc.hateoas.converters.OpenApiHateoasLinksCustomiser;
import org.springdoc.hateoas.converters.RepresentationModelLinksOASMixin;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.LinkRelationProvider;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={LinkRelationProvider.class})
public class SpringDocHateoasConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    HateoasHalProvider hateoasHalProvider(Optional<HateoasProperties> hateoasPropertiesOptional) {
        return new HateoasHalProvider(hateoasPropertiesOptional);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    CollectionModelContentConverter collectionModelContentConverter(HateoasHalProvider halProvider, LinkRelationProvider linkRelationProvider) {
        return halProvider.isHalEnabled() ? new CollectionModelContentConverter(linkRelationProvider) : null;
    }

    @Bean(value={"linksSchemaCustomiser"})
    @ConditionalOnMissingBean
    @Lazy(value=false)
    OpenApiCustomiser linksSchemaCustomiser(HateoasHalProvider halProvider, SpringDocConfigProperties springDocConfigProperties) {
        if (!halProvider.isHalEnabled()) {
            return openApi -> {};
        }
        Json.mapper().addMixIn(RepresentationModel.class, RepresentationModelLinksOASMixin.class);
        return new OpenApiHateoasLinksCustomiser(springDocConfigProperties);
    }
}

