/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.springdoc.core.providers.HateoasHalProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.hateoas.autoconfigure.HateoasProperties;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;

public class DataRestHalProvider
extends HateoasHalProvider
implements InitializingBean {
    private final Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional;

    public DataRestHalProvider(Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional, Optional<HateoasProperties> hateoasPropertiesOptional, ObjectMapperProvider objectMapperProvider) {
        super(hateoasPropertiesOptional, objectMapperProvider);
        this.repositoryRestConfigurationOptional = repositoryRestConfigurationOptional;
    }

    @Override
    public void afterPropertiesSet() {
        if (!this.isHalEnabled()) {
            return;
        }
        if (!Jackson2HalModule.isAlreadyRegisteredIn((ObjectMapper)this.objectMapperProvider.jsonMapper())) {
            this.objectMapperProvider.jsonMapper().registerModule((Module)new Jackson2HalModule());
        }
    }

    @Override
    public boolean isHalEnabled() {
        return this.repositoryRestConfigurationOptional.map(RepositoryRestConfiguration::useHalAsDefaultJsonMediaType).orElse(true);
    }
}

