/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.extractor.DelegatingMethodParameter;
import org.springdoc.core.extractor.MethodParameterPojoExtractor;
import org.springdoc.core.models.ParameterInfo;
import org.springdoc.core.models.RequestBodyInfo;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.WebConversionServiceProvider;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.Resource;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class GenericParameterService {
    private static final List<Class<?>> FILE_TYPES = Collections.synchronizedList(new ArrayList());
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericParameterService.class);
    private final Optional<WebConversionServiceProvider> optionalWebConversionServiceProvider;
    private final PropertyResolverUtils propertyResolverUtils;
    private final BeanExpressionContext expressionContext;
    private final ConfigurableBeanFactory configurableBeanFactory;
    private final ObjectMapperProvider objectMapperProvider;
    private final Optional<JavadocProvider> javadocProviderOptional;

    public GenericParameterService(PropertyResolverUtils propertyResolverUtils, Optional<WebConversionServiceProvider> optionalWebConversionServiceProvider, ObjectMapperProvider objectMapperProvider, Optional<JavadocProvider> javadocProviderOptional) {
        this.propertyResolverUtils = propertyResolverUtils;
        this.optionalWebConversionServiceProvider = optionalWebConversionServiceProvider;
        this.configurableBeanFactory = propertyResolverUtils.getFactory();
        this.expressionContext = this.configurableBeanFactory != null ? new BeanExpressionContext(this.configurableBeanFactory, (Scope)new RequestScope()) : null;
        this.objectMapperProvider = objectMapperProvider;
        this.javadocProviderOptional = javadocProviderOptional;
    }

    public static void addFileType(Class<?> ... classes) {
        FILE_TYPES.addAll(Arrays.asList(classes));
    }

    public static boolean isFile(Class type) {
        return FILE_TYPES.stream().anyMatch(clazz -> clazz.isAssignableFrom(type));
    }

    public static io.swagger.v3.oas.models.parameters.Parameter mergeParameter(List<io.swagger.v3.oas.models.parameters.Parameter> existingParamDoc, io.swagger.v3.oas.models.parameters.Parameter paramCalcul) {
        io.swagger.v3.oas.models.parameters.Parameter result = paramCalcul;
        if (paramCalcul != null && paramCalcul.getName() != null) {
            String name = paramCalcul.getName();
            String in = paramCalcul.getIn();
            io.swagger.v3.oas.models.parameters.Parameter paramDoc = existingParamDoc.stream().filter(p -> name.equals(p.getName()) && (StringUtils.isEmpty((CharSequence)in) || StringUtils.isEmpty((CharSequence)p.getIn()) || in.equals(p.getIn()))).findAny().orElse(null);
            if (paramDoc != null) {
                GenericParameterService.mergeParameter(paramCalcul, paramDoc);
                result = paramDoc;
            } else {
                existingParamDoc.add(result);
            }
        }
        return result;
    }

    public static void mergeParameter(io.swagger.v3.oas.models.parameters.Parameter paramCalcul, io.swagger.v3.oas.models.parameters.Parameter paramDoc) {
        Schema schema;
        if (StringUtils.isBlank((CharSequence)paramDoc.getDescription())) {
            paramDoc.setDescription(paramCalcul.getDescription());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.getIn())) {
            paramDoc.setIn(paramCalcul.getIn());
        }
        if (paramDoc.getExample() == null) {
            paramDoc.setExample(paramCalcul.getExample());
        }
        if (paramDoc.getDeprecated() == null) {
            paramDoc.setDeprecated(paramCalcul.getDeprecated());
        }
        if (paramDoc.getRequired() == null) {
            paramDoc.setRequired(paramCalcul.getRequired());
        }
        if (paramDoc.getAllowEmptyValue() == null) {
            paramDoc.setAllowEmptyValue(paramCalcul.getAllowEmptyValue());
        }
        if (paramDoc.getAllowReserved() == null) {
            paramDoc.setAllowReserved(paramCalcul.getAllowReserved());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.get$ref())) {
            paramDoc.set$ref(paramCalcul.get$ref());
        }
        if (paramDoc.getSchema() == null && paramDoc.getContent() == null) {
            paramDoc.setSchema(paramCalcul.getSchema());
        }
        if (paramDoc.getExamples() == null) {
            paramDoc.setExamples(paramCalcul.getExamples());
        }
        if (paramDoc.getExtensions() == null) {
            paramDoc.setExtensions(paramCalcul.getExtensions());
        }
        if (paramDoc.getStyle() == null) {
            paramDoc.setStyle(paramCalcul.getStyle());
        }
        if (paramDoc.getExplode() == null) {
            paramDoc.setExplode(paramCalcul.getExplode());
        }
        if ((schema = paramDoc.getSchema()) instanceof StringSchema) {
            StringSchema existingSchema = (StringSchema)schema;
            schema = paramCalcul.getSchema();
            if (schema instanceof StringSchema) {
                StringSchema newSchema = (StringSchema)schema;
                ArrayList<String> existingEnums = existingSchema.getEnum() != null ? new ArrayList<String>(existingSchema.getEnum()) : new ArrayList();
                List newEnums = newSchema.getEnum();
                if (newEnums != null && !newEnums.isEmpty()) {
                    for (String val : newEnums) {
                        if (existingEnums.contains(val)) continue;
                        existingEnums.add(val);
                    }
                    existingSchema.setEnum(existingEnums);
                }
                if (newSchema.getDefault() != null) {
                    existingSchema.setDefault(newSchema.getDefault());
                }
            }
        }
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParameterFromDoc(Parameter parameterDoc, Components components, JsonView jsonView, Locale locale) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
            parameter.setDescription(this.propertyResolverUtils.resolve(parameterDoc.description(), locale));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.name())) {
            parameter.setName(this.propertyResolverUtils.resolve(parameterDoc.name(), locale));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.in().toString())) {
            parameter.setIn(parameterDoc.in().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.example())) {
            try {
                parameter.setExample((Object)this.objectMapperProvider.jsonMapper().readTree(parameterDoc.example()));
            }
            catch (IOException e) {
                parameter.setExample((Object)parameterDoc.example());
            }
        }
        if (parameterDoc.deprecated()) {
            parameter.setDeprecated(Boolean.valueOf(parameterDoc.deprecated()));
        }
        if (parameterDoc.required()) {
            parameter.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        if (parameterDoc.allowEmptyValue()) {
            parameter.setAllowEmptyValue(Boolean.valueOf(parameterDoc.allowEmptyValue()));
        }
        if (parameterDoc.allowReserved()) {
            parameter.setAllowReserved(Boolean.valueOf(parameterDoc.allowReserved()));
        }
        if (parameterDoc.content().length > 0) {
            Optional optionalContent = AnnotationsUtils.getContent((Content[])parameterDoc.content(), null, null, null, (Components)components, (JsonView)jsonView, (boolean)this.propertyResolverUtils.isOpenapi31());
            if (this.propertyResolverUtils.isOpenapi31()) {
                optionalContent.ifPresent(SpringDocUtils::handleSchemaTypes);
            }
            optionalContent.ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setContent(arg_0));
        } else {
            this.setSchema(parameterDoc, components, jsonView, parameter);
        }
        this.setExamples(parameterDoc, parameter);
        this.setExtensions(parameterDoc, parameter, locale);
        this.setParameterStyle(parameter, parameterDoc);
        this.setParameterExplode(parameter, parameterDoc);
        return parameter;
    }

    private void setSchema(Parameter parameterDoc, Components components, JsonView jsonView, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.ref())) {
            parameter.$ref(parameterDoc.ref());
        } else {
            Schema schema = null;
            try {
                PrimitiveType primitiveType;
                if (StringUtils.isNotEmpty((CharSequence)parameterDoc.schema().type()) || !Void.class.equals((Object)parameterDoc.schema().implementation())) {
                    schema = AnnotationsUtils.getSchema((io.swagger.v3.oas.annotations.media.Schema)parameterDoc.schema(), null, (boolean)false, (Class)parameterDoc.schema().implementation(), (Components)components, (JsonView)jsonView, (boolean)this.propertyResolverUtils.isOpenapi31()).orElse(null);
                }
                if (schema != null && schema.getDefault() != null && (primitiveType = PrimitiveType.fromTypeAndFormat((String)schema.getType(), (String)schema.getFormat())) != null) {
                    Schema primitiveSchema = primitiveType.createProperty();
                    primitiveSchema.setDefault(schema.getDefault());
                    schema.setDefault(primitiveSchema.getDefault());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Graceful exception occurred", (Throwable)e);
            }
            if (schema == null && parameterDoc.array() != null && (schema = (Schema)AnnotationsUtils.getSchema((io.swagger.v3.oas.annotations.media.Schema)parameterDoc.schema(), (ArraySchema)parameterDoc.array(), (boolean)true, (Class)parameterDoc.array().schema().implementation(), (Components)components, (JsonView)jsonView, (boolean)this.propertyResolverUtils.isOpenapi31()).orElse(null)) != null) {
                Object defaultValue = SpringDocAnnotationsUtils.resolveDefaultValue(parameterDoc.array().arraySchema().defaultValue(), this.objectMapperProvider.jsonMapper());
                schema.setDefault(defaultValue);
            }
            if (this.isOpenapi31()) {
                SpringDocUtils.handleSchemaTypes(schema);
            }
            parameter.setSchema(schema);
        }
    }

    Schema calculateSchema(Components components, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo, JsonView jsonView) {
        Schema schemaN;
        String paramName = parameterInfo.getpName();
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        if (parameterInfo.getParameterModel() == null || parameterInfo.getParameterModel().getSchema() == null) {
            Class<?> type = GenericTypeResolver.resolveType((Type)methodParameter.getGenericParameterType(), (Class)methodParameter.getContainingClass());
            if (type instanceof Class && !((Class)type).isEnum() && this.optionalWebConversionServiceProvider.isPresent()) {
                Class<?> springConvertedType;
                WebConversionServiceProvider webConversionServiceProvider = this.optionalWebConversionServiceProvider.get();
                if (!(MethodParameterPojoExtractor.isSwaggerPrimitiveType(type) || methodParameter.getParameterType().getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class) != null || String.class.equals(springConvertedType = webConversionServiceProvider.getSpringConvertedType(methodParameter.getParameterType())) && ((Class)type).isEnum() || requestBodyInfo != null)) {
                    type = springConvertedType;
                }
            }
            schemaN = SpringDocAnnotationsUtils.extractSchema(components, type, jsonView, SpringDocUtils.getParameterAnnotations(methodParameter), this.propertyResolverUtils.getSpecVersion());
        } else {
            schemaN = parameterInfo.getParameterModel().getSchema();
        }
        if (requestBodyInfo != null) {
            schemaN = this.calculateRequestBodySchema(components, parameterInfo, requestBodyInfo, schemaN, paramName);
            JavadocProvider javadocProvider = this.javadocProviderOptional.orElse(null);
            if (schemaN != null && javadocProvider != null && !this.isRequestBodyPresent(parameterInfo)) {
                String paramJavadocDescription = this.getParamJavadoc(javadocProvider, methodParameter);
                if (schemaN.getProperties() != null && schemaN.getProperties().containsKey(parameterInfo.getpName())) {
                    Map properties = schemaN.getProperties();
                    if (!StringUtils.isBlank((CharSequence)paramJavadocDescription) && StringUtils.isBlank((CharSequence)((Schema)properties.get(parameterInfo.getpName())).getDescription())) {
                        ((Schema)properties.get(parameterInfo.getpName())).setDescription(paramJavadocDescription);
                    }
                }
            }
        }
        return schemaN;
    }

    private Schema calculateRequestBodySchema(Components components, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo, Schema schemaN, String paramName) {
        if (schemaN != null && StringUtils.isEmpty((CharSequence)schemaN.getDescription()) && parameterInfo.getParameterModel() != null) {
            String description = parameterInfo.getParameterModel().getDescription();
            if (schemaN.get$ref() != null && schemaN.get$ref().contains("#/components/schemas/")) {
                String key = schemaN.get$ref().substring("#/components/schemas/".length());
                Schema existingSchema = (Schema)components.getSchemas().get(key);
                if (!StringUtils.isEmpty((CharSequence)description)) {
                    existingSchema.setDescription(description);
                }
            } else {
                schemaN.setDescription(description);
            }
        }
        if (requestBodyInfo.getMergedSchema() != null) {
            requestBodyInfo.getMergedSchema().addProperty(paramName, schemaN);
            schemaN = requestBodyInfo.getMergedSchema();
        } else if (parameterInfo.isRequestPart() || ParameterIn.QUERY.toString().equals(parameterInfo.getParamType()) || schemaN instanceof FileSchema || schemaN != null && schemaN.getItems() instanceof FileSchema) {
            schemaN = new ObjectSchema().addProperty(paramName, schemaN);
            requestBodyInfo.setMergedSchema(schemaN);
        } else {
            requestBodyInfo.addProperties(paramName, schemaN);
        }
        if (requestBodyInfo.getMergedSchema() != null && parameterInfo.isRequired()) {
            requestBodyInfo.getMergedSchema().addRequiredItem(parameterInfo.getpName());
        }
        return schemaN;
    }

    private void setExamples(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        LinkedHashMap exampleMap = new LinkedHashMap();
        if (parameterDoc.examples().length == 1 && StringUtils.isBlank((CharSequence)parameterDoc.examples()[0].name())) {
            Optional exampleOptional = AnnotationsUtils.getExample((ExampleObject)parameterDoc.examples()[0]);
            exampleOptional.ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setExample(arg_0));
        } else {
            for (ExampleObject exampleObject : parameterDoc.examples()) {
                AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
            }
        }
        if (exampleMap.size() > 0) {
            parameter.setExamples(exampleMap);
        }
    }

    private void setExtensions(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter, Locale locale) {
        if (parameterDoc.extensions().length > 0) {
            Map extensionMap = AnnotationsUtils.getExtensions((boolean)this.propertyResolverUtils.isOpenapi31(), (Extension[])parameterDoc.extensions());
            if (this.propertyResolverUtils.isResolveExtensionsProperties()) {
                Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensionMap);
                extensionsResolved.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).addExtension(arg_0, arg_1));
            } else {
                extensionMap.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).addExtension(arg_0, arg_1));
            }
        }
    }

    private void setParameterExplode(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (this.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private void setParameterStyle(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    private boolean isExplodable(Parameter p) {
        io.swagger.v3.oas.annotations.media.Schema schema = p.schema();
        ArraySchema arraySchema = p.array();
        boolean explode = true;
        Class implementation = schema.implementation();
        if (!(implementation != Void.class || schema.type().equals("object") || schema.type().equals("array") || AnnotationsUtils.hasArrayAnnotation((ArraySchema)arraySchema))) {
            explode = false;
        }
        return explode;
    }

    public boolean isFile(MethodParameter methodParameter) {
        if (methodParameter.getGenericParameterType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)methodParameter.getGenericParameterType();
            return this.isFile(parameterizedType);
        }
        Class type = methodParameter.getParameterType();
        return GenericParameterService.isFile(type);
    }

    private boolean isFile(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getActualTypeArguments()[0];
        Class fileClass = ResolvableType.forType((Type)type).getRawClass();
        if (fileClass != null && GenericParameterService.isFile(fileClass)) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            return MultipartFile.class.getName().equals(upperBounds[0].getTypeName());
        }
        return false;
    }

    public PropertyResolverUtils getPropertyResolverUtils() {
        return this.propertyResolverUtils;
    }

    public Optional<WebConversionServiceProvider> getOptionalWebConversionServiceProvider() {
        return this.optionalWebConversionServiceProvider;
    }

    public Object resolveEmbeddedValuesAndExpressions(String value) {
        if (this.configurableBeanFactory == null || this.expressionContext == null) {
            return value;
        }
        String placeholdersResolved = this.configurableBeanFactory.resolveEmbeddedValue(value);
        BeanExpressionResolver exprResolver = this.configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return value;
        }
        return exprResolver.evaluate(placeholdersResolved, this.expressionContext);
    }

    public Parameter generateParameterBySchema(final io.swagger.v3.oas.annotations.media.Schema schema) {
        return new Parameter(){

            public Class<? extends Annotation> annotationType() {
                return Parameter.class;
            }

            public String name() {
                return schema.name();
            }

            public ParameterIn in() {
                return ParameterIn.DEFAULT;
            }

            public String description() {
                return schema.description();
            }

            public boolean required() {
                return schema.requiredMode().equals((Object)Schema.RequiredMode.AUTO) ? schema.required() : schema.requiredMode().equals((Object)Schema.RequiredMode.REQUIRED);
            }

            public boolean deprecated() {
                return schema.deprecated();
            }

            public boolean allowEmptyValue() {
                return false;
            }

            public ParameterStyle style() {
                return ParameterStyle.DEFAULT;
            }

            public Explode explode() {
                return Explode.DEFAULT;
            }

            public boolean allowReserved() {
                return false;
            }

            public io.swagger.v3.oas.annotations.media.Schema schema() {
                return schema;
            }

            public ArraySchema array() {
                return null;
            }

            public Content[] content() {
                return new Content[0];
            }

            public boolean hidden() {
                return schema.hidden();
            }

            public ExampleObject[] examples() {
                return new ExampleObject[0];
            }

            public String example() {
                return schema.example();
            }

            public Extension[] extensions() {
                return schema.extensions();
            }

            public String ref() {
                return schema.ref();
            }

            public Class<?>[] validationGroups() {
                return new Class[0];
            }
        };
    }

    public JavadocProvider getJavadocProvider() {
        return this.javadocProviderOptional.orElse(null);
    }

    public boolean isRequestBodyPresent(ParameterInfo parameterInfo) {
        return parameterInfo.getMethodParameter().getParameterAnnotation(RequestBody.class) != null || parameterInfo.getMethodParameter().getParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class) != null || AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)Objects.requireNonNull(parameterInfo.getMethodParameter().getMethod()), RequestBody.class) != null;
    }

    String getParamJavadoc(JavadocProvider javadocProvider, MethodParameter methodParameter) {
        Field field;
        String fieldJavadoc;
        Map<String, String> recordParamMap;
        String pName = methodParameter.getParameterName();
        DelegatingMethodParameter delegatingMethodParameter = (DelegatingMethodParameter)methodParameter;
        if (!delegatingMethodParameter.isParameterObject()) {
            return javadocProvider.getParamJavadoc(methodParameter.getMethod(), pName);
        }
        String fieldName = StringUtils.isNotEmpty((CharSequence)pName) && pName.contains(".") ? StringUtils.substringAfterLast((String)pName, (String)".") : pName;
        String paramJavadocDescription = null;
        Class<?> cls = ((DelegatingMethodParameter)methodParameter).getExecutable().getDeclaringClass();
        if (cls.getSuperclass() != null && cls.isRecord() && (recordParamMap = javadocProvider.getRecordClassParamJavadoc(cls)).containsKey(fieldName)) {
            paramJavadocDescription = recordParamMap.get(fieldName);
        }
        if (StringUtils.isNotBlank((CharSequence)(fieldJavadoc = javadocProvider.getFieldJavadoc(field = FieldUtils.getDeclaredField(cls, (String)fieldName, (boolean)true))))) {
            paramJavadocDescription = fieldJavadoc;
        }
        return paramJavadocDescription;
    }

    public boolean isOpenapi31() {
        return this.propertyResolverUtils.isOpenapi31();
    }

    static {
        FILE_TYPES.add(MultipartFile.class);
        FILE_TYPES.add(Resource.class);
        FILE_TYPES.add(MultipartRequest.class);
    }
}

