/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import java.util.Optional;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.webmvc.ui.SwaggerIndexTransformer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.ResourceTransformer;

public class SwaggerWebMvcConfigurer
extends WebMvcConfigurerAdapter {
    private String swaggerPath;
    private SwaggerIndexTransformer swaggerIndexTransformer;
    private Optional<ActuatorProvider> actuatorProvider;

    public SwaggerWebMvcConfigurer(SwaggerUiConfigParameters swaggerUiConfigParameters, SwaggerIndexTransformer swaggerIndexTransformer, Optional<ActuatorProvider> actuatorProvider) {
        this.swaggerPath = swaggerUiConfigParameters.getPath();
        this.swaggerIndexTransformer = swaggerIndexTransformer;
        this.actuatorProvider = actuatorProvider;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        if (this.swaggerPath.contains("/")) {
            uiRootPath.append(this.swaggerPath, 0, this.swaggerPath.lastIndexOf("/"));
        }
        if (this.actuatorProvider.isPresent() && this.actuatorProvider.get().isUseManagementPort()) {
            uiRootPath.append(this.actuatorProvider.get().getBasePath());
        }
        uiRootPath.append("/**");
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).resourceChain(false).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }
}

