/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.common.autoconfigure.annotations;

import io.modelcontextprotocol.client.McpClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.method.changed.prompt.SyncPromptListChangedSpecification;
import org.springaicommunity.mcp.method.changed.resource.SyncResourceListChangedSpecification;
import org.springaicommunity.mcp.method.changed.tool.SyncToolListChangedSpecification;
import org.springaicommunity.mcp.method.elicitation.SyncElicitationSpecification;
import org.springaicommunity.mcp.method.logging.SyncLoggingSpecification;
import org.springaicommunity.mcp.method.progress.SyncProgressSpecification;
import org.springaicommunity.mcp.method.sampling.SyncSamplingSpecification;
import org.springframework.ai.mcp.customizer.McpSyncClientCustomizer;
import org.springframework.util.CollectionUtils;

public class McpSyncAnnotationCustomizer
implements McpSyncClientCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(McpSyncAnnotationCustomizer.class);
    private final List<SyncSamplingSpecification> syncSamplingSpecifications;
    private final List<SyncLoggingSpecification> syncLoggingSpecifications;
    private final List<SyncElicitationSpecification> syncElicitationSpecifications;
    private final List<SyncProgressSpecification> syncProgressSpecifications;
    private final List<SyncToolListChangedSpecification> syncToolListChangedSpecifications;
    private final List<SyncResourceListChangedSpecification> syncResourceListChangedSpecifications;
    private final List<SyncPromptListChangedSpecification> syncPromptListChangedSpecifications;
    private final Map<String, Boolean> clientElicitationSpecs = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> clientSamplingSpecs = new ConcurrentHashMap<String, Boolean>();

    public McpSyncAnnotationCustomizer(List<SyncSamplingSpecification> syncSamplingSpecifications, List<SyncLoggingSpecification> syncLoggingSpecifications, List<SyncElicitationSpecification> syncElicitationSpecifications, List<SyncProgressSpecification> syncProgressSpecifications, List<SyncToolListChangedSpecification> syncToolListChangedSpecifications, List<SyncResourceListChangedSpecification> syncResourceListChangedSpecifications, List<SyncPromptListChangedSpecification> syncPromptListChangedSpecifications) {
        this.syncSamplingSpecifications = syncSamplingSpecifications;
        this.syncLoggingSpecifications = syncLoggingSpecifications;
        this.syncElicitationSpecifications = syncElicitationSpecifications;
        this.syncProgressSpecifications = syncProgressSpecifications;
        this.syncToolListChangedSpecifications = syncToolListChangedSpecifications;
        this.syncResourceListChangedSpecifications = syncResourceListChangedSpecifications;
        this.syncPromptListChangedSpecifications = syncPromptListChangedSpecifications;
    }

    public void customize(String name, McpClient.SyncSpec clientSpec) {
        if (!CollectionUtils.isEmpty(this.syncElicitationSpecifications)) {
            this.syncElicitationSpecifications.forEach(elicitationSpec -> Stream.of(elicitationSpec.clients()).forEach(clientId -> {
                if (clientId.equalsIgnoreCase(name)) {
                    if (this.clientElicitationSpecs.containsKey(name)) {
                        throw new IllegalArgumentException("Client '" + name + "' already has an elicitationSpec registered. Only one elicitationSpec is allowed per client.");
                    }
                    this.clientElicitationSpecs.put(name, Boolean.TRUE);
                    clientSpec.elicitation(elicitationSpec.elicitationHandler());
                    logger.info("Registered elicitationSpec for client '{}'.", (Object)name);
                }
            }));
        }
        if (!CollectionUtils.isEmpty(this.syncSamplingSpecifications)) {
            this.syncSamplingSpecifications.forEach(samplingSpec -> Stream.of(samplingSpec.clients()).forEach(clientId -> {
                if (clientId.equalsIgnoreCase(name)) {
                    if (this.clientSamplingSpecs.containsKey(name)) {
                        throw new IllegalArgumentException("Client '" + name + "' already has a samplingSpec registered. Only one samplingSpec is allowed per client.");
                    }
                    this.clientSamplingSpecs.put(name, Boolean.TRUE);
                    clientSpec.sampling(samplingSpec.samplingHandler());
                    logger.info("Registered samplingSpec for client '{}'.", (Object)name);
                }
            }));
        }
        if (!CollectionUtils.isEmpty(this.syncLoggingSpecifications)) {
            this.syncLoggingSpecifications.forEach(loggingSpec -> Stream.of(loggingSpec.clients()).forEach(clientId -> {
                if (clientId.equalsIgnoreCase(name)) {
                    clientSpec.loggingConsumer(loggingSpec.loggingHandler());
                    logger.info("Registered loggingSpec for client '{}'.", (Object)name);
                }
            }));
        }
        if (!CollectionUtils.isEmpty(this.syncProgressSpecifications)) {
            this.syncProgressSpecifications.forEach(progressSpec -> Stream.of(progressSpec.clients()).forEach(clientId -> {
                if (clientId.equalsIgnoreCase(name)) {
                    clientSpec.progressConsumer(progressSpec.progressHandler());
                    logger.info("Registered progressSpec for client '{}'.", (Object)name);
                }
            }));
        }
        if (!CollectionUtils.isEmpty(this.syncToolListChangedSpecifications)) {
            this.syncToolListChangedSpecifications.forEach(toolListChangedSpec -> Stream.of(toolListChangedSpec.clients()).forEach(clientId -> {
                if (clientId.equalsIgnoreCase(name)) {
                    clientSpec.toolsChangeConsumer(toolListChangedSpec.toolListChangeHandler());
                    logger.info("Registered toolListChangedSpec for client '{}'.", (Object)name);
                }
            }));
        }
        if (!CollectionUtils.isEmpty(this.syncResourceListChangedSpecifications)) {
            this.syncResourceListChangedSpecifications.forEach(resourceListChangedSpec -> Stream.of(resourceListChangedSpec.clients()).forEach(clientId -> {
                if (clientId.equalsIgnoreCase(name)) {
                    clientSpec.resourcesChangeConsumer(resourceListChangedSpec.resourceListChangeHandler());
                    logger.info("Registered resourceListChangedSpec for client '{}'.", (Object)name);
                }
            }));
        }
        if (!CollectionUtils.isEmpty(this.syncPromptListChangedSpecifications)) {
            this.syncPromptListChangedSpecifications.forEach(promptListChangedSpec -> Stream.of(promptListChangedSpec.clients()).forEach(clientId -> {
                if (clientId.equalsIgnoreCase(name)) {
                    clientSpec.promptsChangeConsumer(promptListChangedSpec.promptListChangeHandler());
                    logger.info("Registered promptListChangedSpec for client '{}'.", (Object)name);
                }
            }));
        }
    }
}

