/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.transformer.splitter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.ContentFormatter;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentTransformer;

public abstract class TextSplitter
implements DocumentTransformer {
    private static final Logger logger = LoggerFactory.getLogger(TextSplitter.class);
    private boolean copyContentFormatter = true;

    @Override
    public List<Document> apply(List<Document> documents) {
        return this.doSplitDocuments(documents);
    }

    public List<Document> split(List<Document> documents) {
        return this.apply(documents);
    }

    public List<Document> split(Document document) {
        return this.apply(List.of(document));
    }

    public boolean isCopyContentFormatter() {
        return this.copyContentFormatter;
    }

    public void setCopyContentFormatter(boolean copyContentFormatter) {
        this.copyContentFormatter = copyContentFormatter;
    }

    private List<Document> doSplitDocuments(List<Document> documents) {
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<Map<String, Object>> metadataList = new ArrayList<Map<String, Object>>();
        ArrayList<ContentFormatter> formatters = new ArrayList<ContentFormatter>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList<String> originalIds = new ArrayList<String>();
        for (Document doc : documents) {
            texts.add(doc.getText());
            metadataList.add(doc.getMetadata());
            formatters.add(doc.getContentFormatter());
            scores.add(doc.getScore());
            originalIds.add(doc.getId());
        }
        return this.createDocuments(texts, formatters, metadataList, scores, originalIds);
    }

    private List<Document> createDocuments(List<String> texts, List<ContentFormatter> formatters, List<Map<String, Object>> metadataList, List<Double> scores, List<String> originalIds) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (int i = 0; i < texts.size(); ++i) {
            String text = texts.get(i);
            Map<String, Object> metadata = metadataList.get(i);
            Double originalScore = scores.get(i);
            String originalId = originalIds.get(i);
            List<String> chunks = this.splitText(text);
            if (chunks.size() > 1) {
                logger.info("Splitting up document into {} chunks.", (Object)chunks.size());
            }
            for (int chunkIndex = 0; chunkIndex < chunks.size(); ++chunkIndex) {
                String chunk = chunks.get(chunkIndex);
                Map<String, Object> enhancedMetadata = metadata.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                enhancedMetadata.put("parent_document_id", originalId);
                enhancedMetadata.put("chunk_index", chunkIndex);
                enhancedMetadata.put("total_chunks", chunks.size());
                Document newDoc = Document.builder().text(chunk).metadata(enhancedMetadata).score(originalScore).build();
                if (this.copyContentFormatter) {
                    newDoc.setContentFormatter(formatters.get(i));
                }
                documents.add(newDoc);
            }
        }
        return documents;
    }

    protected abstract List<String> splitText(String var1);
}

