/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.cache;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;

public final class CachedContentUpdateRequest {
    @JsonProperty(value="ttl")
    private final Duration ttl;
    @JsonProperty(value="expire_time")
    private final Instant expireTime;

    private CachedContentUpdateRequest(Builder builder) {
        this.ttl = builder.ttl;
        this.expireTime = builder.expireTime;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public String toString() {
        return "CachedContentUpdateRequest{ttl=" + String.valueOf(this.ttl) + ", expireTime=" + String.valueOf(this.expireTime) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration ttl;
        private Instant expireTime;

        private Builder() {
        }

        public Builder ttl(Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public CachedContentUpdateRequest build() {
            if (this.ttl == null && this.expireTime == null) {
                throw new IllegalArgumentException("Either TTL or expire time must be set for update");
            }
            return new CachedContentUpdateRequest(this);
        }
    }
}

