/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.util.CollectionUtils;

public class MistralAiStreamFunctionCallingHelper {
    public MistralAiApi.ChatCompletionChunk merge(MistralAiApi.ChatCompletionChunk previous, MistralAiApi.ChatCompletionChunk current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        Long created = current.created() != null ? current.created() : previous.created();
        String model = current.model() != null ? current.model() : previous.model();
        String object = current.object() != null ? current.object() : previous.object();
        MistralAiApi.ChatCompletionChunk.ChunkChoice previousChoice0 = CollectionUtils.isEmpty(previous.choices()) ? null : previous.choices().get(0);
        MistralAiApi.ChatCompletionChunk.ChunkChoice currentChoice0 = CollectionUtils.isEmpty(current.choices()) ? null : current.choices().get(0);
        MistralAiApi.ChatCompletionChunk.ChunkChoice choice = this.merge(previousChoice0, currentChoice0);
        MistralAiApi.Usage usage = current.usage() != null ? current.usage() : previous.usage();
        return new MistralAiApi.ChatCompletionChunk(id, object, created, model, List.of(choice), usage);
    }

    private MistralAiApi.ChatCompletionChunk.ChunkChoice merge(MistralAiApi.ChatCompletionChunk.ChunkChoice previous, MistralAiApi.ChatCompletionChunk.ChunkChoice current) {
        if (previous == null) {
            Optional<String> id;
            if (current.delta() != null && current.delta().toolCalls() != null && (id = current.delta().toolCalls().stream().map(MistralAiApi.ChatCompletionMessage.ToolCall::id).filter(Objects::nonNull).findFirst()).isEmpty()) {
                String newId = UUID.randomUUID().toString();
                List<MistralAiApi.ChatCompletionMessage.ToolCall> toolCallsWithID = current.delta().toolCalls().stream().map(toolCall -> new MistralAiApi.ChatCompletionMessage.ToolCall(newId, "function", toolCall.function(), toolCall.index())).toList();
                MistralAiApi.ChatCompletionMessage.Role role = current.delta().role() != null ? current.delta().role() : MistralAiApi.ChatCompletionMessage.Role.ASSISTANT;
                current = new MistralAiApi.ChatCompletionChunk.ChunkChoice(current.index(), new MistralAiApi.ChatCompletionMessage(current.delta().content(), role, current.delta().name(), toolCallsWithID), current.finishReason(), current.logprobs());
            }
            return current;
        }
        MistralAiApi.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        Integer index = current.index() != null ? current.index() : previous.index();
        MistralAiApi.ChatCompletionMessage message = this.merge(previous.delta(), current.delta());
        MistralAiApi.LogProbs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        return new MistralAiApi.ChatCompletionChunk.ChunkChoice(index, message, finishReason, logprobs);
    }

    private MistralAiApi.ChatCompletionMessage merge(MistralAiApi.ChatCompletionMessage previous, MistralAiApi.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        MistralAiApi.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : MistralAiApi.ChatCompletionMessage.Role.ASSISTANT;
        String name = current.name() != null ? current.name() : previous.name();
        ArrayList<MistralAiApi.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<MistralAiApi.ChatCompletionMessage.ToolCall>();
        MistralAiApi.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (current.toolCalls() != null) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            MistralAiApi.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (currentToolCall.id() != null) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new MistralAiApi.ChatCompletionMessage(content, role, name, toolCalls);
    }

    private MistralAiApi.ChatCompletionMessage.ToolCall merge(MistralAiApi.ChatCompletionMessage.ToolCall previous, MistralAiApi.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        String type = current.type() != null ? current.type() : previous.type();
        MistralAiApi.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        Integer index = current.index() != null ? current.index() : previous.index();
        return new MistralAiApi.ChatCompletionMessage.ToolCall(id, type, function, index);
    }

    private MistralAiApi.ChatCompletionMessage.ChatCompletionFunction merge(MistralAiApi.ChatCompletionMessage.ChatCompletionFunction previous, MistralAiApi.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = current.name() != null ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new MistralAiApi.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(MistralAiApi.ChatCompletionChunk chatCompletion) {
        List<MistralAiApi.ChatCompletionChunk.ChunkChoice> choices = chatCompletion.choices();
        if (CollectionUtils.isEmpty(choices)) {
            return false;
        }
        MistralAiApi.ChatCompletionChunk.ChunkChoice choice = choices.get(0);
        return !CollectionUtils.isEmpty(choice.delta().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(MistralAiApi.ChatCompletionChunk chatCompletion) {
        List<MistralAiApi.ChatCompletionChunk.ChunkChoice> choices = chatCompletion.choices();
        if (CollectionUtils.isEmpty(choices)) {
            return false;
        }
        MistralAiApi.ChatCompletionChunk.ChunkChoice choice = choices.get(0);
        return choice.finishReason() == MistralAiApi.ChatCompletionFinishReason.TOOL_CALLS;
    }
}

