/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonSerialize(using=ThinkOptionSerializer.class)
@JsonDeserialize(using=ThinkOptionDeserializer.class)
public interface ThinkOption {
    public Object toJsonValue();

    public record ThinkLevel(String level) implements ThinkOption
    {
        private static final List<String> VALID_LEVELS = List.of("low", "medium", "high");
        public static final ThinkLevel LOW = new ThinkLevel("low");
        public static final ThinkLevel MEDIUM = new ThinkLevel("medium");
        public static final ThinkLevel HIGH = new ThinkLevel("high");

        public ThinkLevel {
            if (level != null && !VALID_LEVELS.contains(level)) {
                throw new IllegalArgumentException("think level must be one of " + String.valueOf(VALID_LEVELS) + ", got: " + level);
            }
        }

        @Override
        public Object toJsonValue() {
            return this.level;
        }
    }

    public record ThinkBoolean(boolean enabled) implements ThinkOption
    {
        public static final ThinkBoolean ENABLED = new ThinkBoolean(true);
        public static final ThinkBoolean DISABLED = new ThinkBoolean(false);

        @Override
        public Object toJsonValue() {
            return this.enabled;
        }
    }

    public static class ThinkOptionDeserializer
    extends JsonDeserializer<ThinkOption> {
        public ThinkOption deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonToken token = p.currentToken();
            if (token == JsonToken.VALUE_TRUE) {
                return ThinkBoolean.ENABLED;
            }
            if (token == JsonToken.VALUE_FALSE) {
                return ThinkBoolean.DISABLED;
            }
            if (token == JsonToken.VALUE_STRING) {
                return new ThinkLevel(p.getValueAsString());
            }
            if (token == JsonToken.VALUE_NULL) {
                return null;
            }
            throw new IOException("Cannot deserialize ThinkOption from token: " + String.valueOf(token));
        }
    }

    public static class ThinkOptionSerializer
    extends JsonSerializer<ThinkOption> {
        public void serialize(ThinkOption value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeObject(value.toJsonValue());
            }
        }
    }
}

