/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.WhiteListDeserializingMessageConverter;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.core.NestedIOException;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;

public class SerializerMessageConverter
extends WhiteListDeserializingMessageConverter {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private volatile String defaultCharset = "UTF-8";
    private volatile Serializer<Object> serializer = new DefaultSerializer();
    private volatile Deserializer<Object> deserializer = new DefaultDeserializer();
    private volatile boolean ignoreContentType = false;
    private volatile ClassLoader defaultDeserializerClassLoader;
    private volatile boolean usingDefaultDeserializer = true;

    public void setIgnoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : DEFAULT_CHARSET;
    }

    public void setSerializer(Serializer<Object> serializer) {
        this.serializer = serializer;
    }

    public void setDeserializer(Deserializer<Object> deserializer) {
        this.deserializer = deserializer;
        if (this.deserializer.getClass().equals(DefaultDeserializer.class)) {
            try {
                this.defaultDeserializerClassLoader = (ClassLoader)new DirectFieldAccessor(deserializer).getPropertyValue("classLoader");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.usingDefaultDeserializer = true;
        } else {
            this.usingDefaultDeserializer = false;
        }
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.startsWith("text") && !this.ignoreContentType) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.defaultCharset;
                }
                try {
                    content = new String(message.getBody(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessageConversionException("failed to convert text-based Message content", e);
                }
            }
            if (contentType != null && contentType.equals("application/x-java-serialized-object") || this.ignoreContentType) {
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getBody());
                    content = this.usingDefaultDeserializer ? (Object)this.deserialize(inputStream) : (Object)this.deserializer.deserialize((InputStream)inputStream);
                }
                catch (IOException e) {
                    throw new MessageConversionException("Could not convert message body", e);
                }
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    private Object deserialize(ByteArrayInputStream inputStream) throws IOException {
        try {
            ConfigurableObjectInputStream objectInputStream = new ConfigurableObjectInputStream(inputStream, this.defaultDeserializerClassLoader){

                protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
                    Class clazz = super.resolveClass(classDesc);
                    SerializerMessageConverter.this.checkWhiteList(clazz);
                    return clazz;
                }
            };
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new NestedIOException("Failed to deserialize object type", (Throwable)ex);
        }
    }

    @Override
    protected Message createMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        byte[] bytes;
        if (object instanceof String) {
            try {
                bytes = ((String)object).getBytes(this.defaultCharset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageConversionException("failed to convert Message content", e);
            }
            messageProperties.setContentType("text/plain");
            messageProperties.setContentEncoding(this.defaultCharset);
        } else if (object instanceof byte[]) {
            bytes = (byte[])object;
            messageProperties.setContentType("application/octet-stream");
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                this.serializer.serialize(object, (OutputStream)output);
            }
            catch (IOException e) {
                throw new MessageConversionException("Cannot convert object to bytes", e);
            }
            bytes = output.toByteArray();
            messageProperties.setContentType("application/x-java-serialized-object");
        }
        if (bytes != null) {
            messageProperties.setContentLength(bytes.length);
        }
        return new Message(bytes, messageProperties);
    }
}

