/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJsonMessageConverter;
import org.springframework.amqp.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.Jackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.Assert;

public class Jackson2JsonMessageConverter
extends AbstractJsonMessageConverter
implements SmartMessageConverter {
    private static Log log = LogFactory.getLog(Jackson2JsonMessageConverter.class);
    private final ObjectMapper jsonObjectMapper;
    private Jackson2JavaTypeMapper javaTypeMapper = new DefaultJackson2JavaTypeMapper();
    private boolean typeMapperSet;

    public Jackson2JsonMessageConverter() {
        this("*");
    }

    public Jackson2JsonMessageConverter(String ... trustedPackages) {
        this(new ObjectMapper(), trustedPackages);
        this.jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Jackson2JsonMessageConverter(ObjectMapper jsonObjectMapper) {
        this(jsonObjectMapper, "*");
    }

    public Jackson2JsonMessageConverter(ObjectMapper jsonObjectMapper, String ... trustedPackages) {
        Assert.notNull((Object)jsonObjectMapper, (String)"'jsonObjectMapper' must not be null");
        this.jsonObjectMapper = jsonObjectMapper;
        ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setTrustedPackages(trustedPackages);
    }

    public Jackson2JavaTypeMapper getJavaTypeMapper() {
        return this.javaTypeMapper;
    }

    public void setJavaTypeMapper(Jackson2JavaTypeMapper javaTypeMapper) {
        this.javaTypeMapper = javaTypeMapper;
        this.typeMapperSet = true;
    }

    public Jackson2JavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.javaTypeMapper.getTypePrecedence();
    }

    public void setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence typePrecedence) {
        if (this.typeMapperSet) {
            throw new IllegalStateException("When providing your own type mapper, you should set the precedence on it");
        }
        if (!(this.javaTypeMapper instanceof DefaultJackson2JavaTypeMapper)) {
            throw new IllegalStateException("Type precedence is available with the DefaultJackson2JavaTypeMapper");
        }
        ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setTypePrecedence(typePrecedence);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        if (!this.typeMapperSet) {
            ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setBeanClassLoader(classLoader);
        }
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        return this.fromMessage(message, null);
    }

    @Override
    public Object fromMessage(Message message, Object conversionHint) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.contains("json")) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.getDefaultCharset();
                }
                try {
                    if (conversionHint instanceof ParameterizedTypeReference) {
                        content = this.convertBytesToObject(message.getBody(), encoding, this.jsonObjectMapper.getTypeFactory().constructType(((ParameterizedTypeReference)conversionHint).getType()));
                    }
                    if (this.getClassMapper() == null) {
                        JavaType targetJavaType = this.getJavaTypeMapper().toJavaType(message.getMessageProperties());
                        content = this.convertBytesToObject(message.getBody(), encoding, targetJavaType);
                    }
                    Class<?> targetClass = this.getClassMapper().toClass(message.getMessageProperties());
                    content = this.convertBytesToObject(message.getBody(), encoding, targetClass);
                }
                catch (IOException e) {
                    throw new MessageConversionException("Failed to convert Message content", e);
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Could not convert incoming message with content-type [" + contentType + "]"));
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    private Object convertBytesToObject(byte[] body, String encoding, JavaType targetJavaType) throws IOException {
        String contentAsString = new String(body, encoding);
        return this.jsonObjectMapper.readValue(contentAsString, targetJavaType);
    }

    private Object convertBytesToObject(byte[] body, String encoding, Class<?> targetClass) throws IOException {
        String contentAsString = new String(body, encoding);
        return this.jsonObjectMapper.readValue(contentAsString, this.jsonObjectMapper.constructType(targetClass));
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties) throws MessageConversionException {
        byte[] bytes;
        try {
            String jsonString = this.jsonObjectMapper.writeValueAsString(objectToConvert);
            bytes = jsonString.getBytes(this.getDefaultCharset());
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        messageProperties.setContentType("application/json");
        messageProperties.setContentEncoding(this.getDefaultCharset());
        messageProperties.setContentLength(bytes.length);
        if (this.getClassMapper() == null) {
            this.getJavaTypeMapper().fromJavaType(this.jsonObjectMapper.constructType(objectToConvert.getClass()), messageProperties);
        } else {
            this.getClassMapper().fromClass(objectToConvert.getClass(), messageProperties);
        }
        return new Message(bytes, messageProperties);
    }
}

