/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.RabbitUtils;

public class SimpleConnection
implements Connection {
    private final com.rabbitmq.client.Connection delegate;

    public SimpleConnection(com.rabbitmq.client.Connection delegate) {
        this.delegate = delegate;
    }

    public Channel createChannel(boolean transactional) {
        try {
            Channel channel = this.delegate.createChannel();
            if (transactional) {
                channel.txSelect();
            }
            return channel;
        }
        catch (IOException e) {
            throw RabbitUtils.convertRabbitAccessException(e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw RabbitUtils.convertRabbitAccessException(e);
        }
    }

    public boolean isOpen() {
        return this.delegate != null && this.delegate.isOpen();
    }
}

