/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.ConnectionProxy;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannelImpl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CachingConnectionFactory
extends AbstractConnectionFactory {
    private int channelCacheSize = 1;
    private final LinkedList<ChannelProxy> cachedChannelsNonTransactional = new LinkedList();
    private final LinkedList<ChannelProxy> cachedChannelsTransactional = new LinkedList();
    private volatile boolean active = true;
    private ChannelCachingConnectionProxy connection;
    private volatile boolean publisherConfirms;
    private volatile boolean publisherReturns;
    private final Object connectionMonitor = new Object();

    public CachingConnectionFactory() {
        this((String)null);
    }

    public CachingConnectionFactory(String hostname, int port) {
        super(new ConnectionFactory());
        if (!StringUtils.hasText((String)hostname)) {
            hostname = this.getDefaultHostName();
        }
        this.setHost(hostname);
        this.setPort(port);
    }

    public CachingConnectionFactory(int port) {
        this(null, port);
    }

    public CachingConnectionFactory(String hostname) {
        this(hostname, 5672);
    }

    public CachingConnectionFactory(ConnectionFactory rabbitConnectionFactory) {
        super(rabbitConnectionFactory);
    }

    public void setChannelCacheSize(int sessionCacheSize) {
        Assert.isTrue((sessionCacheSize >= 1 ? 1 : 0) != 0, (String)"Channel cache size must be 1 or higher");
        this.channelCacheSize = sessionCacheSize;
    }

    public int getChannelCacheSize() {
        return this.channelCacheSize;
    }

    public boolean isPublisherConfirms() {
        return this.publisherConfirms;
    }

    public boolean isPublisherReturns() {
        return this.publisherReturns;
    }

    public void setPublisherReturns(boolean publisherReturns) {
        this.publisherReturns = publisherReturns;
    }

    public void setPublisherConfirms(boolean publisherConfirms) {
        this.publisherConfirms = publisherConfirms;
    }

    @Override
    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        super.setConnectionListeners(listeners);
        if (this.connection != null) {
            this.getConnectionListener().onCreate(this.connection);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        super.addConnectionListener(listener);
        if (this.connection != null) {
            listener.onCreate(this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(boolean transactional) {
        LinkedList<ChannelProxy> channelList = transactional ? this.cachedChannelsTransactional : this.cachedChannelsNonTransactional;
        Channel channel = null;
        LinkedList<ChannelProxy> linkedList = channelList;
        synchronized (linkedList) {
            if (!channelList.isEmpty()) {
                channel = channelList.removeFirst();
            }
        }
        if (channel != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Found cached Rabbit Channel");
            }
        } else {
            channel = this.getCachedChannelProxy(channelList, transactional);
        }
        return channel;
    }

    private ChannelProxy getCachedChannelProxy(LinkedList<ChannelProxy> channelList, boolean transactional) {
        Channel targetChannel = this.createBareChannel(transactional);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating cached Rabbit Channel from " + targetChannel));
        }
        this.getChannelListener().onCreate(targetChannel, transactional);
        Class[] interfaces = this.publisherConfirms || this.publisherReturns ? new Class[]{ChannelProxy.class, PublisherCallbackChannel.class} : new Class[]{ChannelProxy.class};
        return (ChannelProxy)Proxy.newProxyInstance(ChannelProxy.class.getClassLoader(), interfaces, (InvocationHandler)new CachedChannelInvocationHandler(targetChannel, channelList, transactional));
    }

    private Channel createBareChannel(boolean transactional) {
        if (this.connection == null || !this.connection.isOpen()) {
            this.connection = null;
            this.createConnection();
        }
        Channel channel = this.connection.createBareChannel(transactional);
        if (this.publisherConfirms) {
            try {
                channel.confirmSelect();
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not configure the channel to receive publisher confirms", (Throwable)e);
            }
        }
        if ((this.publisherConfirms || this.publisherReturns) && !(channel instanceof PublisherCallbackChannelImpl)) {
            channel = new PublisherCallbackChannelImpl(channel);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Connection createConnection() throws AmqpException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.connection = new ChannelCachingConnectionProxy(super.createBareConnection());
                this.getConnectionListener().onCreate(this.connection);
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.destroy();
                this.connection = null;
            }
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        this.active = false;
        LinkedList<ChannelProxy> linkedList = this.cachedChannelsNonTransactional;
        synchronized (linkedList) {
            for (ChannelProxy channel : this.cachedChannelsNonTransactional) {
                try {
                    channel.getTargetChannel().close();
                }
                catch (Throwable ex) {
                    this.logger.trace((Object)"Could not close cached Rabbit Channel", ex);
                }
            }
            this.cachedChannelsNonTransactional.clear();
        }
        linkedList = this.cachedChannelsTransactional;
        synchronized (linkedList) {
            for (ChannelProxy channel : this.cachedChannelsTransactional) {
                try {
                    channel.getTargetChannel().close();
                }
                catch (Throwable ex) {
                    this.logger.trace((Object)"Could not close cached Rabbit Channel", ex);
                }
            }
            this.cachedChannelsTransactional.clear();
        }
        this.active = true;
        this.connection = null;
    }

    public String toString() {
        return "CachingConnectionFactory [channelCacheSize=" + this.channelCacheSize + ", host=" + this.getHost() + ", port=" + this.getPort() + ", active=" + this.active + "]";
    }

    private class ChannelCachingConnectionProxy
    implements Connection,
    ConnectionProxy {
        private volatile Connection target;

        public ChannelCachingConnectionProxy(Connection target) {
            this.target = target;
        }

        private Channel createBareChannel(boolean transactional) {
            return this.target.createChannel(transactional);
        }

        @Override
        public Channel createChannel(boolean transactional) {
            Channel channel = CachingConnectionFactory.this.getChannel(transactional);
            return channel;
        }

        @Override
        public void close() {
        }

        public void destroy() {
            CachingConnectionFactory.this.reset();
            if (this.target != null) {
                CachingConnectionFactory.this.getConnectionListener().onClose(this.target);
                RabbitUtils.closeConnection(this.target);
            }
            this.target = null;
        }

        @Override
        public boolean isOpen() {
            return this.target != null && this.target.isOpen();
        }

        @Override
        public Connection getTargetConnection() {
            return this.target;
        }

        public int hashCode() {
            return 31 + (this.target == null ? 0 : this.target.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChannelCachingConnectionProxy other = (ChannelCachingConnectionProxy)obj;
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }

        public String toString() {
            return "Shared Rabbit Connection: " + this.target;
        }
    }

    private class CachedChannelInvocationHandler
    implements InvocationHandler {
        private volatile Channel target;
        private final LinkedList<ChannelProxy> channelList;
        private final Object targetMonitor = new Object();
        private final boolean transactional;

        public CachedChannelInvocationHandler(Channel target, LinkedList<ChannelProxy> channelList, boolean transactional) {
            this.target = target;
            this.channelList = channelList;
            this.transactional = transactional;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("txSelect") && !this.transactional) {
                throw new UnsupportedOperationException("Cannot start transaction on non-transactional channel");
            }
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("toString")) {
                return "Cached Rabbit Channel: " + this.target;
            }
            if (methodName.equals("close")) {
                if (CachingConnectionFactory.this.active) {
                    LinkedList<ChannelProxy> linkedList = this.channelList;
                    synchronized (linkedList) {
                        if (!RabbitUtils.isPhysicalCloseRequired() && this.channelList.size() < CachingConnectionFactory.this.getChannelCacheSize()) {
                            this.logicalClose((ChannelProxy)proxy);
                            return null;
                        }
                    }
                }
                this.physicalClose();
                return null;
            }
            if (methodName.equals("getTargetChannel")) {
                return this.target;
            }
            if (methodName.equals("isOpen")) {
                return this.target != null && this.target.isOpen();
            }
            try {
                if (this.target == null || !this.target.isOpen()) {
                    this.target = null;
                }
                Object object = this.targetMonitor;
                synchronized (object) {
                    if (this.target == null) {
                        this.target = CachingConnectionFactory.this.createBareChannel(this.transactional);
                    }
                    return method.invoke((Object)this.target, args);
                }
            }
            catch (InvocationTargetException ex) {
                if (this.target == null || !this.target.isOpen()) {
                    this.target = null;
                    CachingConnectionFactory.this.logger.debug((Object)("Detected closed channel on exception.  Re-initializing: " + this.target));
                    Object object = this.targetMonitor;
                    synchronized (object) {
                        if (this.target == null) {
                            this.target = CachingConnectionFactory.this.createBareChannel(this.transactional);
                        }
                    }
                }
                throw ex.getTargetException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logicalClose(ChannelProxy proxy) throws Exception {
            if (this.target != null && !this.target.isOpen()) {
                Object object = this.targetMonitor;
                synchronized (object) {
                    if (this.target != null && !this.target.isOpen()) {
                        this.target = null;
                        return;
                    }
                }
            }
            if (!this.channelList.contains(proxy)) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Returning cached Channel: " + this.target));
                }
                this.channelList.addLast(proxy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void physicalClose() throws Exception {
            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                CachingConnectionFactory.this.logger.debug((Object)("Closing cached Channel: " + this.target));
            }
            if (this.target == null) {
                return;
            }
            if (this.target.isOpen()) {
                Object object = this.targetMonitor;
                synchronized (object) {
                    if (this.target.isOpen()) {
                        this.target.close();
                    }
                    this.target = null;
                }
            }
        }
    }
}

