/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Address;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeConnectionListener;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;

public abstract class AbstractConnectionFactory
implements ConnectionFactory,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory;
    private final CompositeConnectionListener connectionListener = new CompositeConnectionListener();
    private final CompositeChannelListener channelListener = new CompositeChannelListener();
    private volatile ExecutorService executorService;
    private volatile Address[] addresses;
    public static final int DEFAULT_CLOSE_TIMEOUT = 30000;
    private volatile int closeTimeout = 30000;

    public AbstractConnectionFactory(com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory) {
        Assert.notNull((Object)rabbitConnectionFactory, (String)"Target ConnectionFactory must not be null");
        this.rabbitConnectionFactory = rabbitConnectionFactory;
    }

    public void setUsername(String username) {
        this.rabbitConnectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.rabbitConnectionFactory.setPassword(password);
    }

    public void setHost(String host) {
        this.rabbitConnectionFactory.setHost(host);
    }

    @Override
    public String getHost() {
        return this.rabbitConnectionFactory.getHost();
    }

    public void setVirtualHost(String virtualHost) {
        this.rabbitConnectionFactory.setVirtualHost(virtualHost);
    }

    @Override
    public String getVirtualHost() {
        return this.rabbitConnectionFactory.getVirtualHost();
    }

    public void setPort(int port) {
        this.rabbitConnectionFactory.setPort(port);
    }

    public void setRequestedHeartBeat(int requestedHeartBeat) {
        this.rabbitConnectionFactory.setRequestedHeartbeat(requestedHeartBeat);
    }

    @Override
    public int getPort() {
        return this.rabbitConnectionFactory.getPort();
    }

    public void setAddresses(String addresses) {
        Address[] addressArray = Address.parseAddresses((String)addresses);
        if (addressArray.length > 0) {
            this.addresses = addressArray;
        }
    }

    protected ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    protected ChannelListener getChannelListener() {
        return this.channelListener;
    }

    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        this.connectionListener.setDelegates(listeners);
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListener.addDelegate(listener);
    }

    public void setChannelListeners(List<? extends ChannelListener> listeners) {
        this.channelListener.setDelegates(listeners);
    }

    public void addChannelListener(ChannelListener listener) {
        this.channelListener.addDelegate(listener);
    }

    public void setExecutor(Executor executor) {
        boolean isExecutorService = executor instanceof ExecutorService;
        boolean isThreadPoolTaskExecutor = executor instanceof ThreadPoolTaskExecutor;
        Assert.isTrue((isExecutorService || isThreadPoolTaskExecutor ? 1 : 0) != 0);
        this.executorService = isExecutorService ? (ExecutorService)executor : ((ThreadPoolTaskExecutor)executor).getThreadPoolExecutor();
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    protected final Connection createBareConnection() {
        try {
            if (this.addresses != null) {
                return new SimpleConnection(this.rabbitConnectionFactory.newConnection(this.executorService, this.addresses), this.closeTimeout);
            }
            return new SimpleConnection(this.rabbitConnectionFactory.newConnection(this.executorService), this.closeTimeout);
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    protected final String getDefaultHostName() {
        String temp;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            temp = localMachine.getHostName();
            this.logger.debug((Object)("Using hostname [" + temp + "] for hostname."));
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Could not get host name, using 'localhost' as default value", (Throwable)e);
            temp = "localhost";
        }
        return temp;
    }

    public void destroy() {
    }
}

