/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.config.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class RabbitListenerEndpointRegistry
implements DisposableBean,
SmartLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, MessageListenerContainer> listenerContainers = new LinkedHashMap<String, MessageListenerContainer>();
    private int phase = Integer.MAX_VALUE;

    public MessageListenerContainer getListenerContainer(String id) {
        Assert.hasText((String)id, (String)"Container identifier must not be empty");
        return this.listenerContainers.get(id);
    }

    public Collection<MessageListenerContainer> getListenerContainers() {
        return Collections.unmodifiableCollection(this.listenerContainers.values());
    }

    public void registerListenerContainer(RabbitListenerEndpoint endpoint, RabbitListenerContainerFactory<?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.notNull(factory, (String)"Factory must not be null");
        String id = endpoint.getId();
        Assert.hasText((String)id, (String)"Endpoint id must not be empty");
        Assert.state((!this.listenerContainers.containsKey(id) ? 1 : 0) != 0, (String)("Another endpoint is already registered with id '" + id + "'"));
        MessageListenerContainer container = this.createListenerContainer(endpoint, factory);
        this.listenerContainers.put(id, container);
    }

    protected MessageListenerContainer createListenerContainer(RabbitListenerEndpoint endpoint, RabbitListenerContainerFactory<?> factory) {
        int containerPhase;
        Object listenerContainer = factory.createListenerContainer(endpoint);
        if (listenerContainer instanceof InitializingBean) {
            try {
                ((InitializingBean)listenerContainer).afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Failed to initialize message listener container", (Throwable)ex);
            }
        }
        if ((containerPhase = listenerContainer.getPhase()) < Integer.MAX_VALUE) {
            if (this.phase < Integer.MAX_VALUE && this.phase != containerPhase) {
                throw new IllegalStateException("Encountered phase mismatch between container factory definitions: " + this.phase + " vs " + containerPhase);
            }
            this.phase = listenerContainer.getPhase();
        }
        return listenerContainer;
    }

    public void destroy() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            if (!(listenerContainer instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)listenerContainer).destroy();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Failed to destroy message listener container", ex);
            }
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            if (!listenerContainer.isAutoStartup()) continue;
            listenerContainer.start();
        }
    }

    public void stop() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            listenerContainer.stop();
        }
    }

    public void stop(Runnable callback) {
        Collection<MessageListenerContainer> listenerContainers = this.getListenerContainers();
        AggregatingCallback aggregatingCallback = new AggregatingCallback(listenerContainers.size(), callback);
        for (MessageListenerContainer listenerContainer : listenerContainers) {
            listenerContainer.stop(aggregatingCallback);
        }
    }

    public boolean isRunning() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            if (!listenerContainer.isRunning()) continue;
            return true;
        }
        return false;
    }

    private static class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        public AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() == 0) {
                this.finishCallback.run();
            }
        }
    }
}

