/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    private InvocableHandlerMethod handlerMethod;
    private final MessagingMessageConverterAdapter messagingMessageConverter = new MessagingMessageConverterAdapter();

    public void setHandlerMethod(InvocableHandlerMethod handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    @Override
    public void onMessage(org.springframework.amqp.core.Message amqpMessage, Channel channel) throws Exception {
        Object result;
        Message<?> message = this.toMessagingMessage(amqpMessage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        if ((result = this.invokeHandler(amqpMessage, channel, message)) != null) {
            this.handleResult(result, amqpMessage, channel);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        return (Message)this.getMessagingMessageConverter().fromMessage(amqpMessage);
    }

    private Object invokeHandler(org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) {
        try {
            return this.handlerMethod.invoke(message, new Object[]{amqpMessage, channel});
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message"), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerMethod.getMethod().toGenericString() + "' threw exception", ex);
        }
    }

    private String createMessagingErrorMessage(String description) {
        return description + "\n" + "Endpoint handler details:\n" + "Method [" + this.handlerMethod.getMethod() + "]\n" + "Bean [" + this.handlerMethod.getBean() + "]";
    }

    @Override
    protected org.springframework.amqp.core.Message buildMessage(Channel channel, Object result) throws Exception {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof org.springframework.amqp.core.Message)) {
            if (result instanceof Message) {
                return this.messagingMessageConverter.toMessage(result, new MessageProperties());
            }
            return converter.toMessage(result, new MessageProperties());
        }
        if (!(result instanceof org.springframework.amqp.core.Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (org.springframework.amqp.core.Message)result;
    }

    private class MessagingMessageConverterAdapter
    extends MessagingMessageConverter {
        private MessagingMessageConverterAdapter() {
        }

        protected Object extractPayload(org.springframework.amqp.core.Message message) {
            return MessagingMessageListenerAdapter.this.extractMessage(message);
        }
    }
}

