/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.adapter.DelegatingInvocableHandler;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class MultiMethodRabbitListenerEndpoint
extends MethodRabbitListenerEndpoint {
    private final List<Method> methods;
    private final Object bean;

    public MultiMethodRabbitListenerEndpoint(List<Method> methods, Object bean) {
        this.methods = methods;
        this.bean = bean;
    }

    @Override
    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter messageListener) {
        ArrayList<InvocableHandlerMethod> invocableHandlerMethods = new ArrayList<InvocableHandlerMethod>();
        for (Method method : this.methods) {
            invocableHandlerMethods.add(this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(this.getBean(), method));
        }
        return new HandlerAdapter(new DelegatingInvocableHandler(invocableHandlerMethods, this.bean));
    }
}

