/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.listener.ActiveObjectCounter;
import org.springframework.amqp.rabbit.listener.MessageRejectedWhileStoppingException;
import org.springframework.amqp.rabbit.listener.QueuesNotAvailableException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.util.backoff.BackOffExecution;

public class BlockingQueueConsumer {
    private static Log logger = LogFactory.getLog(BlockingQueueConsumer.class);
    private final BlockingQueue<Delivery> queue;
    private volatile ShutdownSignalException shutdown;
    private final String[] queues;
    private final int prefetchCount;
    private final boolean transactional;
    private Channel channel;
    private RabbitResourceHolder resourceHolder;
    private InternalConsumer consumer;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean cancelReceived = new AtomicBoolean(false);
    private final AcknowledgeMode acknowledgeMode;
    private final ConnectionFactory connectionFactory;
    private final MessagePropertiesConverter messagePropertiesConverter;
    private final ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter;
    private final Map<String, Object> consumerArgs = new HashMap<String, Object>();
    private final boolean exclusive;
    private final Set<Long> deliveryTags = new LinkedHashSet<Long>();
    private final boolean defaultRequeuRejected;
    private final Map<String, String> consumerTags = new ConcurrentHashMap<String, String>();
    private final Set<String> missingQueues = Collections.synchronizedSet(new HashSet());
    private long retryDeclarationInterval = 60000L;
    private long failedDeclarationRetryInterval = 5000L;
    private int declarationRetries = 3;
    private long lastRetryDeclaration;
    private ConsumerTagStrategy tagStrategy;
    private BackOffExecution backOffExecution;

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, true, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, (Map<String, Object>)null, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, Map<String, Object> consumerArgs, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, consumerArgs, false, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, Map<String, Object> consumerArgs, boolean exclusive, String ... queues) {
        this.connectionFactory = connectionFactory;
        this.messagePropertiesConverter = messagePropertiesConverter;
        this.activeObjectCounter = activeObjectCounter;
        this.acknowledgeMode = acknowledgeMode;
        this.transactional = transactional;
        this.prefetchCount = prefetchCount;
        this.defaultRequeuRejected = defaultRequeueRejected;
        if (consumerArgs != null && consumerArgs.size() > 0) {
            this.consumerArgs.putAll(consumerArgs);
        }
        this.exclusive = exclusive;
        this.queues = queues;
        this.queue = new LinkedBlockingQueue<Delivery>(prefetchCount);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getConsumerTag() {
        return this.consumer.getConsumerTag();
    }

    @Deprecated
    public final void setQuiesce(long shutdownTimeout) {
    }

    public void setDeclarationRetries(int declarationRetries) {
        this.declarationRetries = declarationRetries;
    }

    public void setFailedDeclarationRetryInterval(long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public void setRetryDeclarationInterval(long retryDeclarationInterval) {
        this.retryDeclarationInterval = retryDeclarationInterval;
    }

    public void setTagStrategy(ConsumerTagStrategy tagStrategy) {
        this.tagStrategy = tagStrategy;
    }

    public void setBackOffExecution(BackOffExecution backOffExecution) {
        this.backOffExecution = backOffExecution;
    }

    public BackOffExecution getBackOffExecution() {
        return this.backOffExecution;
    }

    protected void basicCancel() {
        for (String consumerTag : this.consumerTags.keySet()) {
            try {
                this.channel.basicCancel(consumerTag);
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Error performing 'basicCancel'", (Throwable)e);
            }
            catch (AlreadyClosedException e) {
                if (!logger.isTraceEnabled()) break;
                logger.trace((Object)(this.channel + " is already closed"));
                break;
            }
        }
        this.consumerTags.clear();
        this.cancelled.set(true);
    }

    protected boolean hasDelivery() {
        return !this.queue.isEmpty();
    }

    private void checkShutdown() {
        if (this.shutdown != null) {
            throw (ShutdownSignalException)Utility.fixStackTrace((Throwable)this.shutdown);
        }
    }

    private Message handle(Delivery delivery) throws InterruptedException {
        if (delivery == null && this.shutdown != null) {
            throw this.shutdown;
        }
        if (delivery == null) {
            return null;
        }
        byte[] body = delivery.getBody();
        Envelope envelope = delivery.getEnvelope();
        MessageProperties messageProperties = this.messagePropertiesConverter.toMessageProperties(delivery.getProperties(), envelope, "UTF-8");
        messageProperties.setMessageCount(Integer.valueOf(0));
        messageProperties.setConsumerTag(delivery.getConsumerTag());
        messageProperties.setConsumerQueue(this.consumerTags.get(delivery.getConsumerTag()));
        Message message = new Message(body, messageProperties);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received message: " + message));
        }
        this.deliveryTags.add(messageProperties.getDeliveryTag());
        return message;
    }

    public Message nextMessage() throws InterruptedException, ShutdownSignalException {
        logger.trace((Object)("Retrieving delivery for " + this));
        return this.handle(this.queue.take());
    }

    public Message nextMessage(long timeout) throws InterruptedException, ShutdownSignalException {
        Message message;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving delivery for " + this));
        }
        this.checkShutdown();
        if (this.missingQueues.size() > 0) {
            this.checkMissingQueues();
        }
        if ((message = this.handle(this.queue.poll(timeout, TimeUnit.MILLISECONDS))) == null && this.cancelReceived.get()) {
            throw new ConsumerCancelledException();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMissingQueues() {
        long now = System.currentTimeMillis();
        if (now - this.retryDeclarationInterval > this.lastRetryDeclaration) {
            Set<String> set = this.missingQueues;
            synchronized (set) {
                Iterator<String> iterator = this.missingQueues.iterator();
                while (iterator.hasNext()) {
                    boolean available = true;
                    String queue = iterator.next();
                    Channel channel = null;
                    try {
                        channel = this.connectionFactory.createConnection().createChannel(false);
                        channel.queueDeclarePassive(queue);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Queue '" + queue + "' is now available"));
                        }
                    }
                    catch (IOException e) {
                        available = false;
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Queue '" + queue + "' is still not available"));
                        }
                    }
                    finally {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                            }
                            catch (TimeoutException e) {}
                        }
                    }
                    if (!available) continue;
                    try {
                        this.consumeFromQueue(queue);
                        iterator.remove();
                    }
                    catch (IOException e) {
                        throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                    }
                }
            }
            this.lastRetryDeclaration = now;
        }
    }

    public void start() throws AmqpException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting consumer " + this));
        }
        try {
            this.resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(this.connectionFactory, this.transactional);
            this.channel = this.resourceHolder.getChannel();
        }
        catch (AmqpAuthenticationException e) {
            throw new FatalListenerStartupException("Authentication failure", e);
        }
        this.consumer = new InternalConsumer(this.channel);
        this.deliveryTags.clear();
        this.activeObjectCounter.add(this);
        int passiveDeclareRetries = this.declarationRetries;
        do {
            try {
                this.attemptPassiveDeclarations();
                if (passiveDeclareRetries < this.declarationRetries && logger.isInfoEnabled()) {
                    logger.info((Object)"Queue declaration succeeded after retrying");
                }
                passiveDeclareRetries = 0;
            }
            catch (DeclarationException e) {
                if (passiveDeclareRetries > 0 && this.channel.isOpen()) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)("Queue declaration failed; retries left=" + passiveDeclareRetries), (Throwable)((Object)e));
                    try {
                        Thread.sleep(this.failedDeclarationRetryInterval);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (e.getFailedQueues().size() < this.queues.length) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Not all queues are available; only listening on those that are - configured: " + Arrays.asList(this.queues) + "; not available: " + e.getFailedQueues()));
                    }
                    this.missingQueues.addAll(e.getFailedQueues());
                    this.lastRetryDeclaration = System.currentTimeMillis();
                    continue;
                }
                this.activeObjectCounter.release(this);
                throw new QueuesNotAvailableException("Cannot prepare queue for listener. Either the queue doesn't exist or the broker will not allow us to use it.", (Throwable)((Object)e));
            }
        } while (passiveDeclareRetries-- > 0);
        if (!this.acknowledgeMode.isAutoAck()) {
            try {
                this.channel.basicQos(this.prefetchCount);
            }
            catch (IOException e) {
                this.activeObjectCounter.release(this);
                throw new AmqpIOException(e);
            }
        }
        try {
            for (String queueName : this.queues) {
                if (this.missingQueues.contains(queueName)) continue;
                this.consumeFromQueue(queueName);
            }
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    private void consumeFromQueue(String queue) throws IOException {
        String consumerTag = this.channel.basicConsume(queue, this.acknowledgeMode.isAutoAck(), this.tagStrategy != null ? this.tagStrategy.createConsumerTag(queue) : "", false, this.exclusive, this.consumerArgs, (Consumer)this.consumer);
        if (consumerTag != null) {
            this.consumerTags.put(consumerTag, queue);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started on queue '" + queue + "' with tag " + consumerTag + ": " + this));
            }
        } else {
            logger.error((Object)("Null consumer tag received for queue " + queue));
        }
    }

    private void attemptPassiveDeclarations() {
        DeclarationException failures = null;
        for (String queueName : this.queues) {
            try {
                try {
                    this.channel.queueDeclarePassive(queueName);
                }
                catch (IllegalArgumentException e) {
                    try {
                        if (this.channel instanceof ChannelProxy) {
                            ((ChannelProxy)this.channel).getTargetChannel().close();
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    throw new FatalListenerStartupException("Illegal Argument on Queue Declaration", e);
                }
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to declare queue:" + queueName));
                }
                if (!this.channel.isOpen()) {
                    throw new AmqpIOException(e);
                }
                if (failures == null) {
                    failures = new DeclarationException(e);
                }
                failures.addFailedQueue(queueName);
            }
        }
        if (failures != null) {
            throw failures;
        }
    }

    public void stop() {
        block4: {
            this.cancelled.set(true);
            if (this.consumer != null && this.consumer.getChannel() != null && this.consumerTags.size() > 0 && !this.cancelReceived.get()) {
                try {
                    RabbitUtils.closeMessageConsumer(this.consumer.getChannel(), this.consumerTags.keySet(), this.transactional);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error closing consumer", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing Rabbit Channel: " + this.channel));
        }
        RabbitUtils.setPhysicalCloseRequired(true);
        ConnectionFactoryUtils.releaseResources(this.resourceHolder);
        this.deliveryTags.clear();
        this.consumer = null;
    }

    public String toString() {
        return "Consumer: tags=[" + this.consumerTags.toString() + "], channel=" + this.channel + ", acknowledgeMode=" + this.acknowledgeMode + " local queue size=" + this.queue.size();
    }

    public void rollbackOnExceptionIfNecessary(Throwable ex) throws Exception {
        boolean ackRequired = !this.acknowledgeMode.isAutoAck() && !this.acknowledgeMode.isManual();
        try {
            if (this.transactional) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Initiating transaction rollback on application exception: " + ex));
                }
                RabbitUtils.rollbackIfNecessary(this.channel);
            }
            if (ackRequired) {
                boolean shouldRequeue = this.defaultRequeuRejected || ex instanceof MessageRejectedWhileStoppingException;
                for (Throwable t = ex; shouldRequeue && t != null; t = t.getCause()) {
                    if (!(t instanceof AmqpRejectAndDontRequeueException)) continue;
                    shouldRequeue = false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rejecting messages (requeue=" + shouldRequeue + ")"));
                }
                for (Long deliveryTag : this.deliveryTags) {
                    this.channel.basicReject(deliveryTag.longValue(), shouldRequeue);
                }
                if (this.transactional) {
                    RabbitUtils.commitIfNecessary(this.channel);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw e;
        }
        finally {
            this.deliveryTags.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitIfNecessary(boolean locallyTransacted) throws IOException {
        if (this.deliveryTags.isEmpty()) {
            return false;
        }
        try {
            boolean ackRequired;
            boolean bl = ackRequired = !this.acknowledgeMode.isAutoAck() && !this.acknowledgeMode.isManual();
            if (ackRequired) {
                if (this.transactional && !locallyTransacted) {
                    for (Long deliveryTag : this.deliveryTags) {
                        ConnectionFactoryUtils.registerDeliveryTag(this.connectionFactory, this.channel, deliveryTag);
                    }
                } else {
                    long deliveryTag = new ArrayList<Long>(this.deliveryTags).get(this.deliveryTags.size() - 1);
                    this.channel.basicAck(deliveryTag, true);
                }
            }
            if (locallyTransacted) {
                RabbitUtils.commitIfNecessary(this.channel);
            }
        }
        finally {
            this.deliveryTags.clear();
        }
        return true;
    }

    private static class DeclarationException
    extends AmqpException {
        private final List<String> failedQueues = new ArrayList<String>();

        private DeclarationException() {
            super("Failed to declare queue(s):");
        }

        private DeclarationException(Throwable t) {
            super("Failed to declare queue(s):", t);
        }

        private void addFailedQueue(String queue) {
            this.failedQueues.add(queue);
        }

        private List<String> getFailedQueues() {
            return this.failedQueues;
        }

        public String getMessage() {
            return super.getMessage() + this.failedQueues.toString();
        }
    }

    private static class Delivery {
        private final String consumerTag;
        private final Envelope envelope;
        private final AMQP.BasicProperties properties;
        private final byte[] body;

        public Delivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
            this.consumerTag = consumerTag;
            this.envelope = envelope;
            this.properties = properties;
            this.body = body;
        }

        public String getConsumerTag() {
            return this.consumerTag;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public AMQP.BasicProperties getProperties() {
            return this.properties;
        }

        public byte[] getBody() {
            return this.body;
        }
    }

    private class InternalConsumer
    extends DefaultConsumer {
        private InternalConsumer(Channel channel) {
            super(channel);
        }

        public void handleConsumeOk(String consumerTag) {
            super.handleConsumeOk(consumerTag);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ConsumeOK : " + BlockingQueueConsumer.this));
            }
        }

        public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
            if (logger.isDebugEnabled()) {
                if (RabbitUtils.isNormalShutdown(sig)) {
                    logger.debug((Object)("Received shutdown signal for consumer tag=" + consumerTag + ": " + sig.getMessage()));
                } else {
                    logger.debug((Object)("Received shutdown signal for consumer tag=" + consumerTag), (Throwable)sig);
                }
            }
            BlockingQueueConsumer.this.shutdown = sig;
            BlockingQueueConsumer.this.deliveryTags.clear();
            BlockingQueueConsumer.this.activeObjectCounter.release(BlockingQueueConsumer.this);
        }

        public void handleCancel(String consumerTag) throws IOException {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Cancel received for " + consumerTag + "; " + BlockingQueueConsumer.this));
            }
            BlockingQueueConsumer.this.consumerTags.remove(consumerTag);
            BlockingQueueConsumer.this.cancelReceived.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCancelOk(String consumerTag) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received cancellation notice for tag " + consumerTag + "; " + BlockingQueueConsumer.this));
            }
            Map map = BlockingQueueConsumer.this.consumerTags;
            synchronized (map) {
                BlockingQueueConsumer.this.consumerTags.remove(consumerTag);
            }
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Storing delivery for " + BlockingQueueConsumer.this));
            }
            try {
                BlockingQueueConsumer.this.queue.put(new Delivery(consumerTag, envelope, properties, body));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

