/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConsumerChannelRegistry;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class ConnectionFactoryUtils {
    private ConnectionFactoryUtils() {
    }

    public static boolean isChannelTransactional(Channel channel, ConnectionFactory connectionFactory) {
        if (channel == null || connectionFactory == null) {
            return false;
        }
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        return resourceHolder != null && resourceHolder.containsChannel(channel);
    }

    public static RabbitResourceHolder getTransactionalResourceHolder(final ConnectionFactory connectionFactory, final boolean synchedLocalTransactionAllowed) {
        return ConnectionFactoryUtils.doGetTransactionalResourceHolder(connectionFactory, new ResourceFactory(){

            @Override
            public Channel getChannel(RabbitResourceHolder holder) {
                return holder.getChannel();
            }

            @Override
            public Connection getConnection(RabbitResourceHolder holder) {
                return holder.getConnection();
            }

            @Override
            public Connection createConnection() throws IOException {
                return connectionFactory.createConnection();
            }

            @Override
            public Channel createChannel(Connection con) throws IOException {
                return con.createChannel(synchedLocalTransactionAllowed);
            }

            @Override
            public boolean isSynchedLocalTransactionAllowed() {
                return synchedLocalTransactionAllowed;
            }
        });
    }

    private static RabbitResourceHolder doGetTransactionalResourceHolder(ConnectionFactory connectionFactory, ResourceFactory resourceFactory) {
        Channel channel;
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        Assert.notNull((Object)resourceFactory, (String)"ResourceFactory must not be null");
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        if (resourceHolder != null && (channel = resourceFactory.getChannel(resourceHolder)) != null) {
            return resourceHolder;
        }
        RabbitResourceHolder resourceHolderToUse = resourceHolder;
        if (resourceHolderToUse == null) {
            resourceHolderToUse = new RabbitResourceHolder();
        }
        Connection connection = resourceFactory.getConnection(resourceHolderToUse);
        Channel channel2 = null;
        try {
            channel2 = ConsumerChannelRegistry.getConsumerChannel(connectionFactory);
            if (channel2 == null && connection == null) {
                connection = resourceFactory.createConnection();
                resourceHolderToUse.addConnection(connection);
            }
            if (channel2 == null) {
                channel2 = resourceFactory.createChannel(connection);
            }
            resourceHolderToUse.addChannel(channel2, connection);
            if (resourceHolderToUse != resourceHolder) {
                ConnectionFactoryUtils.bindResourceToTransaction(resourceHolderToUse, connectionFactory, resourceFactory.isSynchedLocalTransactionAllowed());
            }
            return resourceHolderToUse;
        }
        catch (IOException ex) {
            RabbitUtils.closeConnection(connection);
            throw new AmqpIOException(ex);
        }
    }

    public static void releaseResources(RabbitResourceHolder resourceHolder) {
        if (resourceHolder == null || resourceHolder.isSynchronizedWithTransaction()) {
            return;
        }
        RabbitUtils.closeChannel(resourceHolder.getChannel());
        RabbitUtils.closeConnection(resourceHolder.getConnection());
    }

    public static void bindResourceToTransaction(RabbitResourceHolder resourceHolder, ConnectionFactory connectionFactory, boolean synched) {
        if (TransactionSynchronizationManager.hasResource((Object)connectionFactory) || !TransactionSynchronizationManager.isActualTransactionActive() || !synched) {
            return;
        }
        TransactionSynchronizationManager.bindResource((Object)connectionFactory, (Object)((Object)resourceHolder));
        resourceHolder.setSynchronizedWithTransaction(true);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new RabbitResourceSynchronization(resourceHolder, connectionFactory));
        }
    }

    public static void registerDeliveryTag(ConnectionFactory connectionFactory, Channel channel, Long tag) throws IOException {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        if (resourceHolder != null) {
            resourceHolder.addDeliveryTag(channel, tag);
        }
    }

    private static final class RabbitResourceSynchronization
    extends ResourceHolderSynchronization<RabbitResourceHolder, Object> {
        private final RabbitResourceHolder resourceHolder;

        private RabbitResourceSynchronization(RabbitResourceHolder resourceHolder, Object resourceKey) {
            super((ResourceHolder)resourceHolder, resourceKey);
            this.resourceHolder = resourceHolder;
        }

        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        public void afterCompletion(int status) {
            if (status == 0) {
                this.resourceHolder.commitAll();
            } else {
                this.resourceHolder.rollbackAll();
            }
            if (this.resourceHolder.isReleaseAfterCompletion()) {
                this.resourceHolder.setSynchronizedWithTransaction(false);
            }
            super.afterCompletion(status);
        }

        protected void releaseResource(RabbitResourceHolder resourceHolder, Object resourceKey) {
            ConnectionFactoryUtils.releaseResources(resourceHolder);
        }
    }

    public static interface ResourceFactory {
        public Channel getChannel(RabbitResourceHolder var1);

        public Connection getConnection(RabbitResourceHolder var1);

        public Connection createConnection() throws IOException;

        public Channel createChannel(Connection var1) throws IOException;

        public boolean isSynchedLocalTransactionAllowed();
    }
}

