/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.log4j2;

import com.rabbitmq.client.ConnectionFactory;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.DeclareExchangeConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.LogAppenderUtils;

@Plugin(name="RabbitMQ", category="Core", elementType="appender", printObject=true)
public class AmqpAppender
extends AbstractAppender {
    public static final String APPLICATION_ID = "applicationId";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String CATEGORY_LEVEL = "level";
    private final AmqpManager manager;
    private final RabbitTemplate rabbitTemplate = new RabbitTemplate();
    private final LinkedBlockingQueue<Event> events = new LinkedBlockingQueue();
    private final Object layoutMutex = new Object();

    public AmqpAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, AmqpManager manager) {
        super(name, filter, layout, ignoreExceptions);
        this.manager = manager;
    }

    @PluginFactory
    public static AmqpAppender createAppender(@PluginConfiguration Configuration configuration, @PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="host") String host, @PluginAttribute(value="port") int port, @PluginAttribute(value="addresses") String addresses, @PluginAttribute(value="user") String user, @PluginAttribute(value="password") String password, @PluginAttribute(value="virtualHost") String virtualHost, @PluginAttribute(value="senderPoolSize") int senderPoolSize, @PluginAttribute(value="maxSenderRetries") int maxSenderRetries, @PluginAttribute(value="applicationId") String applicationId, @PluginAttribute(value="routingKeyPattern") String routingKeyPattern, @PluginAttribute(value="generateId") boolean generateId, @PluginAttribute(value="deliveryMode") String deliveryMode, @PluginAttribute(value="exchange") String exchange, @PluginAttribute(value="exchangeType") String exchangeType, @PluginAttribute(value="declareExchange") boolean declareExchange, @PluginAttribute(value="durable") boolean durable, @PluginAttribute(value="autoDelete") boolean autoDelete, @PluginAttribute(value="contentType") String contentType, @PluginAttribute(value="contentEncoding") String contentEncoding, @PluginAttribute(value="clientConnectionProperties") String clientConnectionProperties, @PluginAttribute(value="charset") String charset) {
        PatternLayout theLayout;
        if (name == null) {
            LOGGER.error("No name for AmqpAppender");
        }
        if ((theLayout = layout) == null) {
            theLayout = PatternLayout.createDefaultLayout();
        }
        AmqpManager manager = new AmqpManager(configuration.getLoggerContext(), name);
        manager.host = host;
        manager.port = port;
        manager.addresses = addresses;
        manager.username = user;
        manager.password = password;
        manager.virtualHost = virtualHost;
        manager.senderPoolSize = senderPoolSize;
        manager.maxSenderRetries = maxSenderRetries;
        manager.applicationId = applicationId;
        manager.routingKeyPattern = routingKeyPattern;
        manager.generateId = generateId;
        manager.deliveryMode = MessageDeliveryMode.valueOf((String)deliveryMode);
        manager.exchangeName = exchange;
        manager.exchangeType = exchangeType;
        manager.declareExchange = declareExchange;
        manager.durable = durable;
        manager.autoDelete = autoDelete;
        manager.contentType = contentType;
        manager.contentEncoding = contentEncoding;
        manager.clientConnectionProperties = clientConnectionProperties;
        manager.charset = charset;
        AmqpAppender appender = new AmqpAppender(name, filter, (Layout<? extends Serializable>)theLayout, ignoreExceptions, manager);
        if (manager.activateOptions()) {
            appender.startSenders();
            return appender;
        }
        return null;
    }

    private void startSenders() {
        for (int i = 0; i < this.manager.senderPoolSize; ++i) {
            this.manager.senderPool.submit(new EventSender());
        }
    }

    public void append(LogEvent event) {
        this.events.add(new Event(event, event.getContextData().toMap()));
    }

    public Message postProcessMessageBeforeSend(Message message, Event event) {
        return message;
    }

    protected static class AmqpManager
    extends AbstractManager {
        private String exchangeName = "logs";
        private String exchangeType = "topic";
        private String routingKeyPattern = "%c.%p";
        private Layout<String> routingKeyLayout;
        private String applicationId = null;
        private int senderPoolSize = 2;
        private int maxSenderRetries = 30;
        private AbstractConnectionFactory connectionFactory;
        private String host = "localhost";
        private String addresses;
        private String virtualHost = "/";
        private int port = 5672;
        private String username = "guest";
        private String password = "guest";
        private String contentType = "text/plain";
        private String contentEncoding = null;
        private boolean declareExchange = false;
        private String clientConnectionProperties;
        private String charset = Charset.defaultCharset().name();
        private boolean durable = true;
        private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;
        private boolean autoDelete = false;
        private boolean generateId = false;
        private ExecutorService senderPool = null;
        private final Timer retryTimer = new Timer("log-event-retry-delay", true);

        protected AmqpManager(LoggerContext loggerContext, String name) {
            super(loggerContext, name);
        }

        private boolean activateOptions() {
            ConnectionFactory rabbitConnectionFactory = this.createRabbitConnectionFactory();
            if (rabbitConnectionFactory != null) {
                this.routingKeyLayout = PatternLayout.createLayout((String)this.routingKeyPattern.replaceAll("%X\\{applicationId\\}", this.applicationId), null, null, null, (Charset)Charset.forName(this.charset), (boolean)false, (boolean)true, null, null);
                this.connectionFactory = new CachingConnectionFactory(this.createRabbitConnectionFactory());
                if (this.addresses != null) {
                    this.connectionFactory.setAddresses(this.addresses);
                }
                if (this.clientConnectionProperties != null) {
                    LogAppenderUtils.updateClientConnectionProperties(this.connectionFactory, this.clientConnectionProperties);
                }
                this.setUpExchangeDeclaration();
                this.senderPool = Executors.newCachedThreadPool();
                return true;
            }
            return false;
        }

        protected ConnectionFactory createRabbitConnectionFactory() {
            RabbitConnectionFactoryBean factoryBean = new RabbitConnectionFactoryBean();
            this.configureRabbitConnectionFactory(factoryBean);
            try {
                factoryBean.afterPropertiesSet();
                return (ConnectionFactory)factoryBean.getObject();
            }
            catch (Exception e) {
                LOGGER.error("Failed to create customized Rabbit ConnectionFactory.", (Throwable)e);
                return null;
            }
        }

        protected void configureRabbitConnectionFactory(RabbitConnectionFactoryBean factoryBean) {
            factoryBean.setHost(this.host);
            factoryBean.setPort(this.port);
            factoryBean.setUsername(this.username);
            factoryBean.setPassword(this.password);
            factoryBean.setVirtualHost(this.virtualHost);
        }

        protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
            this.retryTimer.cancel();
            this.senderPool.shutdownNow();
            this.connectionFactory.destroy();
            try {
                return this.senderPool.awaitTermination(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }

        protected void setUpExchangeDeclaration() {
            RabbitAdmin admin = new RabbitAdmin(this.connectionFactory);
            if (this.declareExchange) {
                Object x = "topic".equals(this.exchangeType) ? new TopicExchange(this.exchangeName, this.durable, this.autoDelete) : ("direct".equals(this.exchangeType) ? new DirectExchange(this.exchangeName, this.durable, this.autoDelete) : ("fanout".equals(this.exchangeType) ? new FanoutExchange(this.exchangeName, this.durable, this.autoDelete) : ("headers".equals(this.exchangeType) ? new HeadersExchange(this.exchangeType, this.durable, this.autoDelete) : new TopicExchange(this.exchangeName, this.durable, this.autoDelete))));
                this.connectionFactory.addConnectionListener(new DeclareExchangeConnectionListener((Exchange)x, admin));
            }
        }
    }

    protected static class Event {
        private final LogEvent event;
        private final Map properties;
        private final AtomicInteger retries = new AtomicInteger(0);

        public Event(LogEvent event, Map properties) {
            this.event = event;
            this.properties = properties;
        }

        public LogEvent getEvent() {
            return this.event;
        }

        public Map getProperties() {
            return this.properties;
        }

        public int incrementRetries() {
            return this.retries.incrementAndGet();
        }
    }

    protected class EventSender
    implements Runnable {
        protected EventSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RabbitTemplate rabbitTemplate = AmqpAppender.this.rabbitTemplate;
                rabbitTemplate.setConnectionFactory(AmqpAppender.this.manager.connectionFactory);
                while (true) {
                    final Event event = (Event)AmqpAppender.this.events.take();
                    LogEvent logEvent = event.getEvent();
                    String name = logEvent.getLoggerName();
                    Level level = logEvent.getLevel();
                    MessageProperties amqpProps = new MessageProperties();
                    amqpProps.setDeliveryMode(AmqpAppender.this.manager.deliveryMode);
                    amqpProps.setContentType(AmqpAppender.this.manager.contentType);
                    if (null != AmqpAppender.this.manager.contentEncoding) {
                        amqpProps.setContentEncoding(AmqpAppender.this.manager.contentEncoding);
                    }
                    amqpProps.setHeader(AmqpAppender.CATEGORY_NAME, (Object)name);
                    amqpProps.setHeader(AmqpAppender.CATEGORY_LEVEL, (Object)level.toString());
                    if (AmqpAppender.this.manager.generateId) {
                        amqpProps.setMessageId(UUID.randomUUID().toString());
                    }
                    if (null != AmqpAppender.this.manager.applicationId) {
                        amqpProps.setAppId(AmqpAppender.this.manager.applicationId);
                    }
                    Calendar tstamp = Calendar.getInstance();
                    tstamp.setTimeInMillis(logEvent.getTimeMillis());
                    amqpProps.setTimestamp(tstamp.getTime());
                    Map props = event.getProperties();
                    Set entrySet = props.entrySet();
                    for (Map.Entry entry : entrySet) {
                        amqpProps.setHeader(entry.getKey().toString(), entry.getValue());
                    }
                    if (logEvent.getSource() != null) {
                        amqpProps.setHeader("location", (Object)String.format("%s.%s()[%s]", logEvent.getSource().getClassName(), logEvent.getSource().getMethodName(), logEvent.getSource().getLineNumber()));
                    }
                    try {
                        String routingKey;
                        StringBuilder msgBody;
                        Object object = AmqpAppender.this.layoutMutex;
                        synchronized (object) {
                            msgBody = new StringBuilder(new String(AmqpAppender.this.getLayout().toByteArray(logEvent), "UTF-8"));
                            routingKey = new String(AmqpAppender.this.manager.routingKeyLayout.toByteArray(logEvent), "UTF-8");
                        }
                        Message message = null;
                        if (AmqpAppender.this.manager.charset != null) {
                            try {
                                message = new Message(msgBody.toString().getBytes(AmqpAppender.this.manager.charset), amqpProps);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        if (message == null) {
                            message = new Message(msgBody.toString().getBytes(), amqpProps);
                        }
                        message = AmqpAppender.this.postProcessMessageBeforeSend(message, event);
                        rabbitTemplate.send(AmqpAppender.this.manager.exchangeName, routingKey, message);
                    }
                    catch (AmqpException e) {
                        int retries = event.incrementRetries();
                        if (retries < AmqpAppender.this.manager.maxSenderRetries) {
                            AmqpAppender.this.manager.retryTimer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    AmqpAppender.this.events.add(event);
                                }
                            }, (long)(Math.pow(retries, Math.log(retries)) * 1000.0));
                            continue;
                        }
                        AmqpAppender.this.getHandler().error("Could not send log message " + logEvent.getMessage() + " after " + AmqpAppender.this.manager.maxSenderRetries + " retries", logEvent, (Throwable)e);
                    }
                    catch (Exception e) {
                        AmqpAppender.this.getHandler().error("Could not send log message " + logEvent.getMessage(), logEvent, (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

