/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.lang.Nullable;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public abstract class AbstractRabbitListenerContainerFactory<C extends AbstractMessageListenerContainer>
implements RabbitListenerContainerFactory<C>,
ApplicationContextAware,
ApplicationEventPublisherAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AtomicInteger counter = new AtomicInteger();
    private ConnectionFactory connectionFactory;
    private ErrorHandler errorHandler;
    private MessageConverter messageConverter;
    private AcknowledgeMode acknowledgeMode;
    private Boolean channelTransacted;
    private Executor taskExecutor;
    private PlatformTransactionManager transactionManager;
    private Integer prefetchCount;
    private Boolean defaultRequeueRejected;
    private Advice[] adviceChain;
    private BackOff recoveryBackOff;
    private Boolean missingQueuesFatal;
    private Boolean mismatchedQueuesFatal;
    private ConsumerTagStrategy consumerTagStrategy;
    private Long idleEventInterval;
    private Long failedDeclarationRetryInterval;
    private ApplicationEventPublisher applicationEventPublisher;
    private ApplicationContext applicationContext;
    private Boolean autoStartup;
    private Integer phase;
    private MessagePostProcessor[] afterReceivePostProcessors;
    private MessagePostProcessor[] beforeSendReplyPostProcessors;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<?> recoveryCallback;
    private Consumer<C> containerConfigurer;

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setChannelTransacted(Boolean channelTransacted) {
        this.channelTransacted = channelTransacted;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setPrefetchCount(Integer prefetch) {
        this.prefetchCount = prefetch;
    }

    public void setDefaultRequeueRejected(Boolean requeueRejected) {
        this.defaultRequeueRejected = requeueRejected;
    }

    @Nullable
    public Advice[] getAdviceChain() {
        return this.adviceChain == null ? null : Arrays.copyOf(this.adviceChain, this.adviceChain.length);
    }

    public void setAdviceChain(Advice ... adviceChain) {
        this.adviceChain = adviceChain == null ? null : Arrays.copyOf(adviceChain, adviceChain.length);
    }

    public void setRecoveryInterval(Long recoveryInterval) {
        this.recoveryBackOff = new FixedBackOff(recoveryInterval.longValue(), Long.MAX_VALUE);
    }

    public void setRecoveryBackOff(BackOff recoveryBackOff) {
        this.recoveryBackOff = recoveryBackOff;
    }

    public void setMissingQueuesFatal(Boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
    }

    public void setMismatchedQueuesFatal(Boolean mismatchedQueuesFatal) {
        this.mismatchedQueuesFatal = mismatchedQueuesFatal;
    }

    public void setConsumerTagStrategy(ConsumerTagStrategy consumerTagStrategy) {
        this.consumerTagStrategy = consumerTagStrategy;
    }

    public void setIdleEventInterval(Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setFailedDeclarationRetryInterval(Long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        this.afterReceivePostProcessors = afterReceivePostProcessors;
    }

    public void setBeforeSendReplyPostProcessors(MessagePostProcessor ... beforeSendReplyPostProcessors) {
        this.beforeSendReplyPostProcessors = beforeSendReplyPostProcessors;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setReplyRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setContainerConfigurer(Consumer<C> configurer) {
        this.containerConfigurer = configurer;
    }

    @Override
    public C createListenerContainer(RabbitListenerEndpoint endpoint) {
        C instance = this.createContainerInstance();
        JavaUtils javaUtils = JavaUtils.INSTANCE.acceptIfNotNull((Object)this.connectionFactory, arg_0 -> instance.setConnectionFactory(arg_0)).acceptIfNotNull((Object)this.errorHandler, arg_0 -> instance.setErrorHandler(arg_0));
        if (this.messageConverter != null) {
            if (endpoint != null) {
                endpoint.setMessageConverter(this.messageConverter);
                if (endpoint.getMessageConverter() == null) {
                    ((AbstractMessageListenerContainer)instance).setMessageConverter(this.messageConverter);
                }
            } else {
                ((AbstractMessageListenerContainer)instance).setMessageConverter(this.messageConverter);
            }
        }
        javaUtils.acceptIfNotNull((Object)this.acknowledgeMode, arg_0 -> instance.setAcknowledgeMode(arg_0)).acceptIfNotNull((Object)this.channelTransacted, arg_0 -> instance.setChannelTransacted(arg_0)).acceptIfNotNull((Object)this.applicationContext, arg_0 -> instance.setApplicationContext(arg_0)).acceptIfNotNull((Object)this.taskExecutor, arg_0 -> instance.setTaskExecutor(arg_0)).acceptIfNotNull((Object)this.transactionManager, arg_0 -> instance.setTransactionManager(arg_0)).acceptIfNotNull((Object)this.prefetchCount, arg_0 -> instance.setPrefetchCount(arg_0)).acceptIfNotNull((Object)this.defaultRequeueRejected, arg_0 -> instance.setDefaultRequeueRejected(arg_0)).acceptIfNotNull((Object)this.adviceChain, arg_0 -> instance.setAdviceChain(arg_0)).acceptIfNotNull((Object)this.recoveryBackOff, arg_0 -> instance.setRecoveryBackOff(arg_0)).acceptIfNotNull((Object)this.mismatchedQueuesFatal, arg_0 -> instance.setMismatchedQueuesFatal(arg_0)).acceptIfNotNull((Object)this.missingQueuesFatal, arg_0 -> instance.setMissingQueuesFatal(arg_0)).acceptIfNotNull((Object)this.consumerTagStrategy, arg_0 -> instance.setConsumerTagStrategy(arg_0)).acceptIfNotNull((Object)this.idleEventInterval, arg_0 -> instance.setIdleEventInterval(arg_0)).acceptIfNotNull((Object)this.failedDeclarationRetryInterval, arg_0 -> instance.setFailedDeclarationRetryInterval(arg_0)).acceptIfNotNull((Object)this.applicationEventPublisher, arg_0 -> instance.setApplicationEventPublisher(arg_0)).acceptIfNotNull((Object)this.autoStartup, arg_0 -> instance.setAutoStartup(arg_0)).acceptIfNotNull((Object)this.phase, arg_0 -> instance.setPhase(arg_0)).acceptIfNotNull((Object)this.afterReceivePostProcessors, arg_0 -> instance.setAfterReceivePostProcessors(arg_0));
        if (endpoint != null) {
            if (endpoint.getAutoStartup() != null) {
                ((AbstractMessageListenerContainer)instance).setAutoStartup(endpoint.getAutoStartup());
            }
            ((AbstractMessageListenerContainer)instance).setListenerId(endpoint.getId());
            endpoint.setupListenerContainer((MessageListenerContainer)instance);
        }
        if (((AbstractMessageListenerContainer)instance).getMessageListener() instanceof AbstractAdaptableMessageListener) {
            AbstractAdaptableMessageListener messageListener = (AbstractAdaptableMessageListener)((AbstractMessageListenerContainer)instance).getMessageListener();
            javaUtils.acceptIfNotNull((Object)this.beforeSendReplyPostProcessors, messageListener::setBeforeSendReplyPostProcessors).acceptIfNotNull((Object)this.retryTemplate, messageListener::setRetryTemplate).acceptIfCondition(this.retryTemplate != null && this.recoveryCallback != null, this.recoveryCallback, messageListener::setRecoveryCallback).acceptIfNotNull((Object)this.defaultRequeueRejected, messageListener::setDefaultRequeueRejected);
        }
        this.initializeContainer(instance, endpoint);
        if (this.containerConfigurer != null) {
            this.containerConfigurer.accept(instance);
        }
        return instance;
    }

    protected abstract C createContainerInstance();

    protected void initializeContainer(C instance, RabbitListenerEndpoint endpoint) {
    }
}

