/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.keygen;

import org.springframework.security.crypto.keygen.AndroidSecureRandomBytesKeyGenerator;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.HexEncodingStringKeyGenerator;
import org.springframework.security.crypto.keygen.SharedKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

public class AndroidKeyGenerators {
    public static BytesKeyGenerator secureRandom() {
        return new AndroidSecureRandomBytesKeyGenerator();
    }

    public static BytesKeyGenerator secureRandom(int keyLength) {
        return new AndroidSecureRandomBytesKeyGenerator(keyLength);
    }

    public static BytesKeyGenerator shared(int keyLength) {
        return new SharedKeyGenerator(AndroidKeyGenerators.secureRandom(16).generateKey());
    }

    public static StringKeyGenerator string() {
        return new HexEncodingStringKeyGenerator(AndroidKeyGenerators.secureRandom());
    }

    private AndroidKeyGenerators() {
    }
}

