/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormHttpMessageConverter
implements HttpMessageConverter<MultiValueMap<String, ?>> {
    private static final byte[] BOUNDARY_CHARS = new byte[]{45, 95, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private final Random rnd = new Random();
    private Charset charset = Charset.forName("UTF-8");
    private List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
    private List<HttpMessageConverter<?>> partConverters = new ArrayList();

    public FormHttpMessageConverter() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
        this.supportedMediaTypes.add(MediaType.MULTIPART_FORM_DATA);
        this.partConverters.add(new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.partConverters.add(stringHttpMessageConverter);
        this.partConverters.add(new ResourceHttpMessageConverter());
    }

    public final void setPartConverters(List<HttpMessageConverter<?>> partConverters) {
        Assert.notEmpty(partConverters, (String)"'partConverters' must not be empty");
        this.partConverters = partConverters;
    }

    public final void addPartConverter(HttpMessageConverter<?> partConverter) {
        Assert.notNull(partConverter, (String)"'partConverter' must not be NULL");
        this.partConverters.add(partConverter);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (supportedMediaType.equals(MediaType.MULTIPART_FORM_DATA) || !supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null || MediaType.ALL.equals(mediaType)) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        this.supportedMediaTypes = supportedMediaTypes;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    @Override
    public MultiValueMap<String, String> read(Class<? extends MultiValueMap<String, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType.getCharSet() != null ? contentType.getCharSet() : this.charset;
        String body = FileCopyUtils.copyToString((Reader)new InputStreamReader(inputMessage.getBody(), charset));
        String[] pairs = StringUtils.tokenizeToStringArray((String)body, (String)"&");
        LinkedMultiValueMap result = new LinkedMultiValueMap(pairs.length);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.add((Object)URLDecoder.decode(pair, charset.name()), null);
                continue;
            }
            String name = URLDecoder.decode(pair.substring(0, idx), charset.name());
            String value = URLDecoder.decode(pair.substring(idx + 1), charset.name());
            result.add((Object)name, (Object)value);
        }
        return result;
    }

    @Override
    public void write(MultiValueMap<String, ?> map, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (!this.isMultipart(map, contentType)) {
            this.writeForm(map, contentType, outputMessage);
        } else {
            this.writeMultipart(map, outputMessage);
        }
    }

    private boolean isMultipart(MultiValueMap<String, ?> map, MediaType contentType) {
        if (contentType != null) {
            return MediaType.MULTIPART_FORM_DATA.equals(contentType);
        }
        for (String name : map.keySet()) {
            for (Object value : (List)map.get((Object)name)) {
                if (value == null || value instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private void writeForm(MultiValueMap<String, String> form, MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        Charset charset;
        if (contentType != null) {
            outputMessage.getHeaders().setContentType(contentType);
            charset = contentType.getCharSet() != null ? contentType.getCharSet() : this.charset;
        } else {
            outputMessage.getHeaders().setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            charset = this.charset;
        }
        StringBuilder builder = new StringBuilder();
        Iterator nameIterator = form.keySet().iterator();
        while (nameIterator.hasNext()) {
            String name = (String)nameIterator.next();
            Iterator valueIterator = ((List)form.get((Object)name)).iterator();
            while (valueIterator.hasNext()) {
                String value = (String)valueIterator.next();
                builder.append(URLEncoder.encode(name, charset.name()));
                if (value == null) continue;
                builder.append('=');
                builder.append(URLEncoder.encode(value, charset.name()));
                if (!valueIterator.hasNext()) continue;
                builder.append('&');
            }
            if (!nameIterator.hasNext()) continue;
            builder.append('&');
        }
        byte[] bytes = builder.toString().getBytes(charset.name());
        outputMessage.getHeaders().setContentLength(bytes.length);
        FileCopyUtils.copy((byte[])bytes, (OutputStream)outputMessage.getBody());
    }

    private void writeMultipart(MultiValueMap<String, Object> parts, HttpOutputMessage outputMessage) throws IOException {
        byte[] boundary = this.generateMultipartBoundary();
        Map<String, String> parameters = Collections.singletonMap("boundary", new String(boundary, "US-ASCII"));
        MediaType contentType = new MediaType(MediaType.MULTIPART_FORM_DATA, parameters);
        outputMessage.getHeaders().setContentType(contentType);
        this.writeParts(outputMessage.getBody(), parts, boundary);
        this.writeEnd(boundary, outputMessage.getBody());
    }

    private void writeParts(OutputStream os, MultiValueMap<String, Object> parts, byte[] boundary) throws IOException {
        for (Map.Entry entry : parts.entrySet()) {
            String name = (String)entry.getKey();
            for (Object part : (List)entry.getValue()) {
                this.writeBoundary(boundary, os);
                HttpEntity<?> entity = this.getEntity(part);
                this.writePart(name, entity, os);
                this.writeNewLine(os);
            }
        }
    }

    private void writeBoundary(byte[] boundary, OutputStream os) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        this.writeNewLine(os);
    }

    private HttpEntity<?> getEntity(Object part) {
        if (part instanceof HttpEntity) {
            return (HttpEntity)part;
        }
        return new HttpEntity<Object>(part);
    }

    private void writePart(String name, HttpEntity<?> partEntity, OutputStream os) throws IOException {
        Object partBody = partEntity.getBody();
        Class<?> partType = partBody.getClass();
        HttpHeaders partHeaders = partEntity.getHeaders();
        MediaType partContentType = partHeaders.getContentType();
        for (HttpMessageConverter<?> messageConverter : this.partConverters) {
            if (!messageConverter.canWrite(partType, partContentType)) continue;
            MultipartHttpOutputMessage multipartOutputMessage = new MultipartHttpOutputMessage(os);
            multipartOutputMessage.getHeaders().setContentDispositionFormData(name, this.getFilename(partBody));
            if (!partHeaders.isEmpty()) {
                multipartOutputMessage.getHeaders().putAll((Map<? extends String, ? extends List<String>>)((Object)partHeaders));
            }
            messageConverter.write(partBody, partContentType, multipartOutputMessage);
            return;
        }
        throw new HttpMessageNotWritableException("Could not write request: no suitable HttpMessageConverter found for request type [" + partType.getName() + "]");
    }

    private void writeEnd(byte[] boundary, OutputStream os) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        os.write(45);
        os.write(45);
        this.writeNewLine(os);
    }

    private void writeNewLine(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    protected byte[] generateMultipartBoundary() {
        byte[] boundary = new byte[this.rnd.nextInt(11) + 30];
        for (int i = 0; i < boundary.length; ++i) {
            boundary[i] = BOUNDARY_CHARS[this.rnd.nextInt(BOUNDARY_CHARS.length)];
        }
        return boundary;
    }

    protected String getFilename(Object part) {
        if (part instanceof Resource) {
            Resource resource = (Resource)part;
            return resource.getFilename();
        }
        return null;
    }

    private class MultipartHttpOutputMessage
    implements HttpOutputMessage {
        private final HttpHeaders headers = new HttpHeaders();
        private final OutputStream os;
        private boolean headersWritten = false;

        public MultipartHttpOutputMessage(OutputStream os) {
            this.os = os;
        }

        public HttpHeaders getHeaders() {
            return this.headersWritten ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
        }

        public OutputStream getBody() throws IOException {
            this.writeHeaders();
            return this.os;
        }

        private void writeHeaders() throws IOException {
            if (!this.headersWritten) {
                for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                    byte[] headerName = this.getAsciiBytes(entry.getKey());
                    for (String headerValueString : entry.getValue()) {
                        byte[] headerValue = this.getAsciiBytes(headerValueString);
                        this.os.write(headerName);
                        this.os.write(58);
                        this.os.write(32);
                        this.os.write(headerValue);
                        FormHttpMessageConverter.this.writeNewLine(this.os);
                    }
                }
                FormHttpMessageConverter.this.writeNewLine(this.os);
                this.headersWritten = true;
            }
        }

        protected byte[] getAsciiBytes(String name) {
            try {
                return name.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

