/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

import org.springframework.batch.core.job.flow.FlowStep;
import org.springframework.batch.core.partition.support.PartitionStep;
import org.springframework.batch.core.step.job.JobStep;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.util.StringUtils;

public enum StepType {
    TASKLET_STEP(TaskletStep.class.getName(), "Tasklet Step"),
    FLOW_STEP(FlowStep.class.getName(), "Flow Step"),
    JOB_STEP(JobStep.class.getName(), "Job Step"),
    PARTITION_STEP(PartitionStep.class.getName(), "Partition Step"),
    UNKNOWN("", "");

    private final String className;
    private final String displayName;

    private StepType(String className, String displayName) {
        this.className = className;
        this.displayName = displayName;
    }

    public static StepType fromClassName(String className) {
        StepType type = UNKNOWN;
        if (StringUtils.hasText((String)className)) {
            String name = className.trim();
            for (StepType curType : StepType.values()) {
                if (!curType.className.equals(name)) continue;
                type = curType;
                break;
            }
        }
        return type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

