/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.service.NoSuchStepExecutionException;
import org.springframework.batch.admin.service.SearchableJobExecutionDao;
import org.springframework.batch.admin.service.SearchableJobInstanceDao;
import org.springframework.batch.admin.service.SearchableStepExecutionDao;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.annotation.Scheduled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJobService
implements JobService,
DisposableBean {
    private static final Log logger = LogFactory.getLog(SimpleJobService.class);
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 60000;
    private final SearchableJobInstanceDao jobInstanceDao;
    private final SearchableJobExecutionDao jobExecutionDao;
    private final JobRepository jobRepository;
    private final JobLauncher jobLauncher;
    private final ListableJobLocator jobLocator;
    private final SearchableStepExecutionDao stepExecutionDao;
    private final ExecutionContextDao executionContextDao;
    private Collection<JobExecution> activeExecutions = Collections.synchronizedList(new ArrayList());
    private int shutdownTimeout = 60000;

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public SimpleJobService(SearchableJobInstanceDao jobInstanceDao, SearchableJobExecutionDao jobExecutionDao, SearchableStepExecutionDao stepExecutionDao, JobRepository jobRepository, JobLauncher jobLauncher, ListableJobLocator jobLocator, ExecutionContextDao executionContextDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
        this.jobRepository = jobRepository;
        this.jobLauncher = jobLauncher;
        this.jobLocator = jobLocator;
        this.executionContextDao = executionContextDao;
    }

    @Override
    public Collection<StepExecution> getStepExecutions(Long jobExecutionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(jobExecutionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("No JobExecution with id=" + jobExecutionId);
        }
        this.stepExecutionDao.addStepExecutions(jobExecution);
        String jobName = jobExecution.getJobInstance() == null ? null : jobExecution.getJobInstance().getJobName();
        LinkedHashSet<String> missingStepNames = new LinkedHashSet<String>();
        if (jobName != null) {
            missingStepNames.addAll(this.stepExecutionDao.findStepNamesForJobExecution(jobName, "*:partition*"));
            logger.debug((Object)("Found step executions in repository: " + missingStepNames));
        }
        Job job = null;
        try {
            job = this.jobLocator.getJob(jobName);
        }
        catch (NoSuchJobException e) {
            // empty catch block
        }
        if (job instanceof StepLocator) {
            Collection stepNames = ((StepLocator)job).getStepNames();
            missingStepNames.addAll(stepNames);
            logger.debug((Object)("Added step executions from job: " + missingStepNames));
        }
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            String stepName = stepExecution.getStepName();
            if (missingStepNames.contains(stepName)) {
                missingStepNames.remove(stepName);
            }
            logger.debug((Object)("Removed step executions from job execution: " + missingStepNames));
        }
        for (String stepName : missingStepNames) {
            StepExecution stepExecution = jobExecution.createStepExecution(stepName);
            stepExecution.setStatus(BatchStatus.UNKNOWN);
        }
        return jobExecution.getStepExecutions();
    }

    @Override
    public boolean isLaunchable(String jobName) {
        return this.jobLocator.getJobNames().contains(jobName);
    }

    @Override
    public JobExecution restart(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, NoSuchJobException, JobParametersInvalidException {
        JobExecution target = this.getJobExecution(jobExecutionId);
        JobInstance lastInstance = target.getJobInstance();
        Job job = this.jobLocator.getJob(lastInstance.getJobName());
        JobExecution jobExecution = this.jobLauncher.run(job, lastInstance.getJobParameters());
        if (jobExecution.isRunning()) {
            this.activeExecutions.add(jobExecution);
        }
        return jobExecution;
    }

    @Override
    public JobExecution launch(String jobName, JobParameters jobParameters) throws NoSuchJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobExecution jobExecution;
        Job job = this.jobLocator.getJob(jobName);
        if (job.getJobParametersIncrementer() != null) {
            Collection<JobInstance> lastInstances = this.listJobInstances(jobName, 0, 1);
            JobInstance lastInstance = null;
            if (!lastInstances.isEmpty()) {
                lastInstance = lastInstances.iterator().next();
            }
            JobParameters oldParameters = new JobParameters();
            if (lastInstance != null) {
                oldParameters = lastInstance.getJobParameters();
            }
            HashMap parameters = new HashMap(oldParameters.getParameters());
            parameters.putAll(jobParameters.getParameters());
            jobParameters = job.getJobParametersIncrementer().getNext(new JobParameters(parameters));
        }
        if ((jobExecution = this.jobLauncher.run(job, jobParameters)).isRunning()) {
            this.activeExecutions.add(jobExecution);
        }
        return jobExecution;
    }

    @Override
    public Collection<JobExecution> listJobExecutions(int start, int count) {
        return this.jobExecutionDao.getJobExecutions(start, count);
    }

    @Override
    public int countJobExecutions() {
        return this.jobExecutionDao.countJobExecutions();
    }

    @Override
    public Collection<String> listJobs(int start, int count) {
        LinkedHashSet jobNames = new LinkedHashSet(this.jobLocator.getJobNames());
        if (start + count > jobNames.size()) {
            jobNames.addAll(this.jobInstanceDao.getJobNames());
        }
        if (start >= jobNames.size()) {
            start = jobNames.size();
        }
        if (start + count >= jobNames.size()) {
            count = jobNames.size() - start;
        }
        return new ArrayList(jobNames).subList(start, start + count);
    }

    @Override
    public int countJobs() {
        HashSet names = new HashSet(this.jobLocator.getJobNames());
        names.addAll(this.jobInstanceDao.getJobNames());
        return names.size();
    }

    @Override
    public int stopAll() {
        Collection<JobExecution> result = this.jobExecutionDao.getRunningJobExecutions();
        for (JobExecution jobExecution : result) {
            jobExecution.stop();
            this.jobRepository.update(jobExecution);
        }
        return result.size();
    }

    @Override
    public JobExecution stop(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        if (!jobExecution.isRunning()) {
            throw new JobExecutionNotRunningException("JobExecution is not running and therefore cannot be stopped");
        }
        logger.info((Object)("Stopping job execution: " + jobExecution));
        jobExecution.stop();
        this.jobRepository.update(jobExecution);
        return jobExecution;
    }

    @Override
    public JobExecution abandon(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        if (jobExecution.getStatus().isLessThan(BatchStatus.STOPPING)) {
            throw new JobExecutionAlreadyRunningException("JobExecution is running or complete and therefore cannot be aborted");
        }
        logger.info((Object)("Aborting job execution: " + jobExecution));
        jobExecution.upgradeStatus(BatchStatus.ABANDONED);
        this.jobRepository.update(jobExecution);
        return jobExecution;
    }

    @Override
    public int countJobExecutionsForJob(String name) throws NoSuchJobException {
        this.checkJobExists(name);
        return this.jobExecutionDao.countJobExecutions(name);
    }

    @Override
    public int countJobInstances(String name) throws NoSuchJobException {
        return this.jobInstanceDao.countJobInstances(name);
    }

    @Override
    public JobExecution getJobExecution(Long jobExecutionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(jobExecutionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("There is no JobExecution with id=" + jobExecutionId);
        }
        jobExecution.setJobInstance(this.jobInstanceDao.getJobInstance(jobExecution));
        jobExecution.setExecutionContext(this.executionContextDao.getExecutionContext(jobExecution));
        this.stepExecutionDao.addStepExecutions(jobExecution);
        return jobExecution;
    }

    @Override
    public Collection<JobExecution> getJobExecutionsForJobInstance(String name, Long jobInstanceId) throws NoSuchJobException {
        this.checkJobExists(name);
        List jobExecutions = this.jobExecutionDao.findJobExecutions(this.jobInstanceDao.getJobInstance(jobInstanceId));
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
        }
        return jobExecutions;
    }

    @Override
    public StepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId) throws NoSuchJobExecutionException, NoSuchStepExecutionException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        StepExecution stepExecution = this.stepExecutionDao.getStepExecution(jobExecution, stepExecutionId);
        if (stepExecution == null) {
            throw new NoSuchStepExecutionException("There is no StepExecution with jobExecutionId=" + jobExecutionId + " and id=" + stepExecutionId);
        }
        stepExecution.setExecutionContext(this.executionContextDao.getExecutionContext(stepExecution));
        return stepExecution;
    }

    @Override
    public Collection<JobExecution> listJobExecutionsForJob(String jobName, int start, int count) throws NoSuchJobException {
        this.checkJobExists(jobName);
        List<JobExecution> jobExecutions = this.jobExecutionDao.getJobExecutions(jobName, start, count);
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
        }
        return jobExecutions;
    }

    @Override
    public Collection<StepExecution> listStepExecutionsForStep(String stepName, int start, int count) throws NoSuchStepException {
        if (this.stepExecutionDao.countStepExecutions(stepName) == 0) {
            throw new NoSuchStepException("No step executions exist with this step name: " + stepName);
        }
        return this.stepExecutionDao.findStepExecutions(stepName, start, count);
    }

    @Override
    public int countStepExecutionsForStep(String stepName) throws NoSuchStepException {
        return this.stepExecutionDao.countStepExecutions(stepName);
    }

    @Override
    public Collection<JobInstance> listJobInstances(String jobName, int start, int count) throws NoSuchJobException {
        this.checkJobExists(jobName);
        return this.jobInstanceDao.getJobInstances(jobName, start, count);
    }

    private void checkJobExists(String jobName) throws NoSuchJobException {
        if (this.jobLocator.getJobNames().contains(jobName)) {
            return;
        }
        if (this.jobInstanceDao.countJobInstances(jobName) > 0) {
            return;
        }
        throw new NoSuchJobException("No Job with that name either current or historic: [" + jobName + "]");
    }

    public void destroy() throws Exception {
        Exception firstException = null;
        for (JobExecution jobExecution : this.activeExecutions) {
            try {
                if (!jobExecution.isRunning()) continue;
                this.stop(jobExecution.getId());
            }
            catch (JobExecutionNotRunningException e) {
                logger.info((Object)"JobExecution is not running so it cannot be stopped");
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected exception stopping JobExecution", (Throwable)e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        int count = 0;
        int maxCount = (this.shutdownTimeout + 1000) / 1000;
        while (!this.activeExecutions.isEmpty() && ++count < maxCount) {
            logger.error((Object)("Waiting for " + this.activeExecutions.size() + " active executions to complete"));
            this.removeInactiveExecutions();
            Thread.sleep(1000L);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void removeInactiveExecutions() {
        Iterator<JobExecution> iterator = this.activeExecutions.iterator();
        while (iterator.hasNext()) {
            JobExecution jobExecution = iterator.next();
            try {
                jobExecution = this.getJobExecution(jobExecution.getId());
            }
            catch (NoSuchJobExecutionException e) {
                logger.error((Object)"Unexpected exception loading JobExecution", (Throwable)e);
            }
            if (jobExecution.isRunning()) continue;
            iterator.remove();
        }
    }
}

