/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.admin.web.JobInfo;
import org.springframework.batch.admin.web.TableUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class JobExecutionController {
    private static Log logger = LogFactory.getLog(JobExecutionController.class);
    private JobService jobService;

    @Autowired
    public JobExecutionController(JobService jobService) {
        this.jobService = jobService;
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}"}, method={RequestMethod.DELETE})
    public String stop(Model model, @ModelAttribute(value="stopRequest") StopRequest stopRequest, Errors errors, @PathVariable Long jobExecutionId) {
        stopRequest.jobExecutionId = jobExecutionId;
        try {
            JobExecution jobExecution = this.jobService.stop(jobExecutionId);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "No job exection with id=" + jobExecutionId);
        }
        catch (JobExecutionNotRunningException e) {
            errors.reject("job.execution.not.running", "Job exection with id=" + jobExecutionId + " is not running.");
            try {
                JobExecution jobExecution = this.jobService.getJobExecution(jobExecutionId);
                model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
            }
            catch (NoSuchJobExecutionException e1) {
                // empty catch block
            }
        }
        return "jobs/execution";
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}"}, method={RequestMethod.DELETE}, params={"abandon"})
    public String abandon(Model model, @ModelAttribute(value="stopRequest") StopRequest stopRequest, Errors errors, @PathVariable Long jobExecutionId) {
        stopRequest.jobExecutionId = jobExecutionId;
        try {
            JobExecution jobExecution = this.jobService.abandon(jobExecutionId);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "No job exection with id=" + jobExecutionId);
        }
        catch (JobExecutionAlreadyRunningException e) {
            errors.reject("job.execution.running", "Job exection with id=" + jobExecutionId + " is running.");
            try {
                JobExecution jobExecution = this.jobService.getJobExecution(jobExecutionId);
                model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
            }
            catch (NoSuchJobExecutionException e1) {
                // empty catch block
            }
        }
        return "jobs/execution";
    }

    @RequestMapping(value={"/jobs/executions", "/jobs/executions.*"}, method={RequestMethod.GET})
    @ModelAttribute(value="jobExecutions")
    public Collection<JobExecutionInfo> list(Model model, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        int total = this.jobService.countJobExecutions();
        TableUtils.addPagination(model, total, startJobExecution, pageSize, "JobExecution");
        ArrayList<JobExecutionInfo> result = new ArrayList<JobExecutionInfo>();
        for (JobExecution jobExecution : this.jobService.listJobExecutions(startJobExecution, pageSize)) {
            result.add(new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
        }
        return result;
    }

    @RequestMapping(value={"/jobs/{jobName}/{jobInstanceId}/executions"}, method={RequestMethod.GET})
    public String listForInstance(Model model, @PathVariable String jobName, @PathVariable long jobInstanceId) {
        ArrayList<JobExecutionInfo> result = new ArrayList<JobExecutionInfo>();
        try {
            for (JobExecution jobExecution : this.jobService.getJobExecutionsForJobInstance(jobName, jobInstanceId)) {
                result.add(new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
            }
        }
        catch (NoSuchJobException e) {
            // empty catch block
        }
        model.addAttribute((Object)new JobInfo(jobName, result.size(), jobInstanceId, null));
        model.addAttribute("jobExecutions", result);
        return "jobs/executions";
    }

    @RequestMapping(value={"/jobs/{jobName}/{jobInstanceId}/executions"}, method={RequestMethod.POST})
    public String restart(Model model, @PathVariable String jobName, @PathVariable long jobInstanceId) {
        try {
            Collection<JobExecution> jobExecutions = this.jobService.getJobExecutionsForJobInstance(jobName, jobInstanceId);
            model.addAttribute((Object)new JobInfo(jobName, jobExecutions.size() + 1));
            JobExecution jobExecution = jobExecutions.iterator().next();
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
            try {
                jobExecution = this.jobService.restart(jobExecution.getId());
                model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
            }
            catch (NoSuchJobExecutionException e) {
            }
            catch (JobExecutionAlreadyRunningException e) {
            }
            catch (JobRestartException e) {
            }
            catch (JobInstanceAlreadyCompleteException e) {
            }
            catch (JobParametersInvalidException e) {}
        }
        catch (NoSuchJobException e) {
            // empty catch block
        }
        return "jobs/execution";
    }

    @RequestMapping(value={"/jobs/executions"}, method={RequestMethod.DELETE})
    @ModelAttribute(value="jobExecutions")
    public Collection<JobExecutionInfo> stopAll(Model model, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        model.addAttribute("stoppedCount", (Object)this.jobService.stopAll());
        return this.list(model, startJobExecution, pageSize);
    }

    @RequestMapping(value={"/jobs/{jobName}/executions"}, method={RequestMethod.GET})
    public String listForJob(Model model, @PathVariable String jobName, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        int total = startJobExecution;
        try {
            total = this.jobService.countJobExecutionsForJob(jobName);
        }
        catch (NoSuchJobException e) {
            logger.warn((Object)("Could not locate Job with name=" + jobName));
        }
        TableUtils.addPagination(model, total, startJobExecution, pageSize, "JobExecution");
        ArrayList<JobExecutionInfo> result = new ArrayList<JobExecutionInfo>();
        try {
            for (JobExecution jobExecution : this.jobService.listJobExecutionsForJob(jobName, startJobExecution, pageSize)) {
                result.add(new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
            }
            int count = this.jobService.countJobExecutionsForJob(jobName);
            model.addAttribute((Object)new JobInfo(jobName, count));
            model.addAttribute("jobExecutions", result);
        }
        catch (NoSuchJobException e) {
            logger.warn((Object)("Could not locate Job with name=" + jobName));
        }
        return "jobs/executions";
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}"}, method={RequestMethod.GET})
    public String detail(Model model, @PathVariable Long jobExecutionId) {
        try {
            JobExecution jobExecution = this.jobService.getJobExecution(jobExecutionId);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
        }
        catch (NoSuchJobExecutionException noSuchJobExecutionException) {
            // empty catch block
        }
        return "jobs/execution";
    }

    public static class StopRequest {
        private Long jobExecutionId;

        public Long getJobExecutionId() {
            return this.jobExecutionId;
        }

        public void setJobExecutionId(Long jobExecutionId) {
            this.jobExecutionId = jobExecutionId;
        }
    }
}

