/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.service.JdbcSearchableJobExecutionDao;
import org.springframework.batch.admin.service.JdbcSearchableJobInstanceDao;
import org.springframework.batch.admin.service.JdbcSearchableStepExecutionDao;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.service.SearchableJobExecutionDao;
import org.springframework.batch.admin.service.SearchableJobInstanceDao;
import org.springframework.batch.admin.service.SearchableStepExecutionDao;
import org.springframework.batch.admin.service.SimpleJobService;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JdbcExecutionContextDao;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJobServiceFactoryBean
implements FactoryBean<JobService>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SimpleJobServiceFactoryBean.class);
    private DataSource dataSource;
    private SimpleJdbcOperations jdbcTemplate;
    private String databaseType;
    private String tablePrefix = "BATCH_";
    private DataFieldMaxValueIncrementerFactory incrementerFactory;
    private int maxVarCharLength = 2500;
    private LobHandler lobHandler;
    private JobRepository jobRepository;
    private JobLauncher jobLauncher;
    private ListableJobLocator jobLocator;

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setMaxVarCharLength(int maxVarCharLength) {
        this.maxVarCharLength = maxVarCharLength;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseType(String dbType) {
        this.databaseType = dbType;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setIncrementerFactory(DataFieldMaxValueIncrementerFactory incrementerFactory) {
        this.incrementerFactory = incrementerFactory;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public void setJobLocator(ListableJobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"DataSource must not be null.");
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must not be null.");
        Assert.notNull((Object)this.jobLocator, (String)"JobLocator must not be null.");
        Assert.notNull((Object)this.jobLauncher, (String)"JobLauncher must not be null.");
        this.jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        if (this.incrementerFactory == null) {
            this.incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(this.dataSource);
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseType.fromMetaData((DataSource)this.dataSource).name();
            logger.info((Object)("No database type set, using meta data indicating: " + this.databaseType));
        }
        if (this.lobHandler == null && this.databaseType.equalsIgnoreCase(DatabaseType.ORACLE.toString())) {
            this.lobHandler = new OracleLobHandler();
        }
        Assert.isTrue((boolean)this.incrementerFactory.isSupportedIncrementerType(this.databaseType), (String)("'" + this.databaseType + "' is an unsupported database type.  The supported database types are " + StringUtils.arrayToCommaDelimitedString((Object[])this.incrementerFactory.getSupportedIncrementerTypes())));
    }

    protected SearchableJobInstanceDao createJobInstanceDao() throws Exception {
        JdbcSearchableJobInstanceDao dao = new JdbcSearchableJobInstanceDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setJobIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }

    protected SearchableJobExecutionDao createJobExecutionDao() throws Exception {
        JdbcSearchableJobExecutionDao dao = new JdbcSearchableJobExecutionDao();
        dao.setDataSource(this.dataSource);
        dao.setJobExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        dao.setExitMessageLength(this.maxVarCharLength);
        dao.afterPropertiesSet();
        return dao;
    }

    protected SearchableStepExecutionDao createStepExecutionDao() throws Exception {
        JdbcSearchableStepExecutionDao dao = new JdbcSearchableStepExecutionDao();
        dao.setDataSource(this.dataSource);
        dao.setStepExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "STEP_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        dao.setExitMessageLength(this.maxVarCharLength);
        dao.afterPropertiesSet();
        return dao;
    }

    protected ExecutionContextDao createExecutionContextDao() throws Exception {
        JdbcExecutionContextDao dao = new JdbcExecutionContextDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        if (this.lobHandler != null) {
            dao.setLobHandler(this.lobHandler);
        }
        dao.afterPropertiesSet();
        dao.setShortContextLength(this.maxVarCharLength);
        return dao;
    }

    private int determineClobTypeToUse(String databaseType) {
        if (DatabaseType.SYBASE == DatabaseType.valueOf((String)databaseType.toUpperCase())) {
            return -1;
        }
        return 2005;
    }

    public JobService getObject() throws Exception {
        return new SimpleJobService(this.createJobInstanceDao(), this.createJobExecutionDao(), this.createStepExecutionDao(), this.jobRepository, this.jobLauncher, this.jobLocator, this.createExecutionContextDao());
    }

    public Class<? extends JobService> getObjectType() {
        return SimpleJobService.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

